//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitFuctory.cpp
 * @brief		UnitTest Fuctory NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_UnitFuctory_CPP_

//======================================================================
// include
#include "UnitFuctory.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

//======================================================================
// IUnitTestFuctory
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	pName		= eXg
 * @param [in]	pSubName	= TueXg
*//***********************************************************************/
IUnitTestFuctory::IUnitTestFuctory(LPCSTR pName, LPCSTR pSubName)
{
	if( pName == nullptr ) return;
	LPCSTR p = strrchr(pName, FILESPEC_DIRECTORY_DELIMITER);
	if( p == nullptr ) p = pName;
	else ++p;
	m_name = p;
	IUnitTestFuctory** pRegister = GetRegister();
	m_next = *pRegister;
	*pRegister = this;
}

IUnitTestFuctory** IUnitTestFuctory::GetRegister(void)
{
	static IUnitTestFuctory* pResister = nullptr; 
	return &pResister; 
}

}	// end of namespace unit
}	// end of namespace iris


#endif
