//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitClass.h
 * @brief		Unit Class t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitClass_H_
#define INCG_IRIS_UnitClass_H_

//======================================================================
// include
#include "../iris_object.h"
#include "../iris_debug.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

//======================================================================
// typedef
//! eXgp֐^
typedef void (*PFN_UnitTestMain)(void);

//======================================================================
// class
//! P̃eXgsC^[tFCXNX
class CUnitTestBase : public IIrisObject
{
public:
	virtual ~CUnitTestBase() {}
public:
	// eXg̎s
	void	Exec(PFN_UnitTestMain pMain);
	// Ȉ
	void	Abort(void);

public:
	/// Ȉ
	virtual void	OnAbort(void)	{}

public:
	// JgeXgNX̎擾
	static	CUnitTestBase*		GetCurrent(void);
};

/**
 * @brief	P̃eXgsNX
 * @tparam	_FUNC	= eXg֐
*/
template<typename _TC>
class CUnitTest : public CUnitTestBase
{
public:
	/// JgeXgNX̎擾
	static	_TC*	GetCurrent(void)	{ return static_cast<_TC*>(CUnitTestBase::GetCurrent()); }
};

}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
