//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqSystem.cpp
 * @brief		squirrel t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqSystem_CPP_

//======================================================================
// include
#include "SqSystem.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

#include "SqError.h"
#include <stdio.h>
#include <stdarg.h>
#include <tchar.h>

//======================================================================
// link
#if		defined(_WIN32) && defined(_MT)
#  if		defined(_DLL)
#    define GT_LIBNAME_MODE	"md"
#  else
#    define GT_LIBNAME_MODE	"mt"
#  endif

#  if		IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
#    define GT_LIBNAME_VC		"2008"
#  else
#    define GT_LIBNAME_VC		"2005"
#  endif

#  if		defined(_WIN64)
#    define GT_LIBNAME_AMD64	"_amd64"
#  else
#    define GT_LIBNAME_AMD64	
#  endif

#  if		defined(_IRIS_DEBUG)
#    define GT_LIBNAME_DEBUG	"d"
#  else
#    define GT_LIBNAME_DEBUG	
#  endif
#endif

#if	defined(IRIS_WIN32)
#pragma comment (lib, "sqstdlib_"	\
				GT_LIBNAME_MODE		\
				GT_LIBNAME_VC		\
				GT_LIBNAME_AMD64	\
				IRIS_LIB_POSTFIX	\
				".lib")
#pragma comment (lib, "squirrel_"	\
				GT_LIBNAME_MODE		\
				GT_LIBNAME_VC		\
				GT_LIBNAME_AMD64	\
				IRIS_LIB_POSTFIX	\
				".lib")
#endif

namespace iris {
namespace sq
{

//======================================================================
// function
/**********************************************************************//**
 * @private
 * @internal
 *
 * squirrel printf
 *
 -----------------------------------------------------------------------
 * @param [in]	vm		= z}V
 * @param [in]	format	= o͕tH[}bg
 * @param [in]	...		= 
*//***********************************************************************/
void _sq_printffunc(HSQUIRRELVM vm, const SQChar* format, ...)
{
	va_list va;
	va_start(va, format);
	_vtprintf(format, va);
	va_end(va);
}
/**********************************************************************//**
 * @private
 * @internal
 *
 * error printf
 *
 -----------------------------------------------------------------------
 * @param [in]	vm		= z}V
 * @param [in]	format	= o͕tH[}bg
 * @param [in]	...		= 
*//***********************************************************************/
void _sq_errorfunc(HSQUIRRELVM vm, const SQChar* format, ...)
{
	va_list va;
	va_start(va, format);
	_vtprintf(format, va);
	va_end(va);
}


//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSquirrel::CSquirrel(void)
: m_VM(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	vm = z}V
*//***********************************************************************/
CSquirrel::CSquirrel(HSQUIRRELVM vm)
: m_VM(vm)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSquirrel::~CSquirrel(void)
{
	Close();
}

/**********************************************************************//**
 *
 * z}VJ
 *
 ----------------------------------------------------------------------
 * @param [in]	initialstacksize = X^bNTCY
*//***********************************************************************/
void CSquirrel::Open(SQInteger initialstacksize)
{
	if( m_VM != nullptr ) return;
	m_VM = sq_open(initialstacksize);
	// Wo͊֐ݒ
	sq_setprintfunc(m_VM, _sq_printffunc, _sq_errorfunc);
	sqstd_seterrorhandlers(m_VM);
}

/**********************************************************************//**
 *
 * z}VJ
 *
*//***********************************************************************/
void CSquirrel::Close(void)
{
	if( m_VM == nullptr ) return;
	sq_close(m_VM);
}

/**********************************************************************//**
 *
 * XNvg̃RpCƎs
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile		= t@CpX
 * @param [in]	retVal		= 
 * @param [in]	printerror	= 
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrel::DoFile(LPCSQSTR lpFile, SQBool retVal, SQBool printerror)
{
	sq_pushroottable(m_VM);
	SQRESULT sr = sqstd_dofile(m_VM, lpFile, retVal, printerror);
	SCSQ_ERROR(sr);
	return sr;
}

/**********************************************************************//**
 *
 * ֐̎s
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName		= ֐
 * @param [in]	num			= ̐
 * @param [in]	...			= CVarinat ^ϒ
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrel::Exec(LPCSQSTR lpName, int num, ...)
{
	SQRESULT ret = SQ_ERROR;
	SQInteger cur = sq_gettop(m_VM);
	sq_pushroottable(m_VM);	// root
	sq_pushstring(m_VM, lpName, -1);
	if( SQ_SUCCEEDED(sq_get(m_VM, -2)) )
	{
		sq_pushroottable(m_VM);	// root
		va_list va;
		va_start(va, num);
		for( int i=0; i < num; ++i )
		{
			IRIS_PRAGMA_MSG_TODO("CVariant ͂߂܂傤")

			CVariant* var = va_arg(va, CVariant*);
			VARTYPE vt = var->GetVarType();
			if( vt & VT_BYREF )
			{
				switch(vt & (~VT_BYREF))
				{
				case VT_I1:
					sq_pushstring(m_VM, var->GetValue<const SQChar*>(), -1);
					break;
				default:
					sq_pushuserpointer(m_VM, var->GetValue<SQUserPointer>());
					break;
				}
			}
			else
			{
				switch(vt & (~VT_BYREF))
				{
				case VT_NULL:
					sq_pushnull(m_VM);
					break;
				case VT_I1:
				case VT_I2:
				case VT_I4:
				case VT_I8:
				case VT_UI1:
				case VT_UI2:
				case VT_UI4:
				case VT_UI8:
					sq_pushinteger(m_VM, var->GetValue<SQInteger>());
					break;
				case VT_R4:
				case VT_R8:
					sq_pushfloat(m_VM, var->GetValue<SQFloat>());
					break;
				case VT_BOOL:
					sq_pushbool(m_VM, var->GetValue<SQBool>());
					break;
				}
			}
		}
		ret = sq_call(m_VM, num+1, SQFalse, SQTrue);
		va_end(va);
	}
	sq_settop(m_VM, cur);
	return ret;
}

/**********************************************************************//**
 *
 * ֐̌ĂяoGg
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName		= ֐
 * @return	֐sIuWFNg
*//***********************************************************************/
CSquirrel::Functor CSquirrel::Func(LPCSQSTR lpName)
{
	Functor func(*this, lpName);
	return func;
}

/**********************************************************************//**
 *
 * ֐o^
 *
 ----------------------------------------------------------------------
 * @param [in]	func		= ֐
 * @param [in]	lpName		= ֐
 * @return	
*//***********************************************************************/
SQRESULT CSquirrel::RegisterFunction(SQFUNCTION func, LPCSQSTR lpName)
{
	SQRESULT ret;
	sq_pushroottable(m_VM);
	sq_pushstring(m_VM, lpName, -1);
	sq_newclosure(m_VM, func, 0);
	ret = sq_createslot(m_VM, -3);
	sq_pop(m_VM, 1);
	return ret;
}

// CSquirrel::Functor
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	sq		= squirrel NX
 * @param [in]	lpName	= ֐
*//***********************************************************************/
CSquirrel::Functor::Functor(CSquirrel& sq, LPCSQSTR lpName)
: m_sq(sq)
, m_args(0)
, m_top(0)
{
	SQRESULT ret = SQ_ERROR;
	m_top = m_sq.GetTop();
	m_sq.PushRootTable();
	m_sq.PushString(lpName, -1);
	if( SQ_SUCCEEDED(sq.Get(-2)) )
	{
		m_sq.PushRootTable();
	}
	else
	{
		m_sq.SetTop(m_top);
		m_args = -1;
	}
}

/**********************************************************************//**
 *
 * ֐̎s
 *
 ----------------------------------------------------------------------
 * @return	Ug
*//***********************************************************************/
SQRESULT CSquirrel::Functor::Call(void)
{
	if( m_args < 0 ) return SQ_ERROR;
	SQRESULT ret = m_sq.Call(m_args+1, SQFalse, SQTrue);
	m_sq.SetTop(m_top);
	return ret;
}

// Utility
/**********************************************************************//**
 *
 * _v֐
 *
 ----------------------------------------------------------------------
 * @param [in]	vm	= z}V
 * @return	
*//***********************************************************************/
SQInteger CSquirrel::Utility::DumpArgs(HSQUIRRELVM vm)
{
	SQInteger num = sq_gettop(vm);
	printf("dump args\n");
	printf("(");
	for(SQInteger i=1; i <= num; ++i)
	{
		if( i!=1 ) printf("\n, ");
#define DUMP(type)	case type: printf(#type); break

		switch(sq_gettype(vm, i))
		{
			DUMP(OT_NULL);
			DUMP(OT_INTEGER);
			DUMP(OT_FLOAT);
			DUMP(OT_BOOL);
			DUMP(OT_STRING);
			DUMP(OT_TABLE);
			DUMP(OT_ARRAY);
			DUMP(OT_USERDATA);
			DUMP(OT_CLOSURE);
			DUMP(OT_NATIVECLOSURE);
			DUMP(OT_GENERATOR);
			DUMP(OT_USERPOINTER);
			DUMP(OT_THREAD);
			DUMP(OT_FUNCPROTO);
			DUMP(OT_CLASS);
			DUMP(OT_INSTANCE);
			DUMP(OT_WEAKREF);
			DUMP(OT_OUTER);
		default:
			return sq_throwerror(vm, IRIS_TEXT("invalid param") );
		}
	}
	printf(")\n");
	sq_pushinteger(vm, num);
	return 1;
}

}	// end of namespace sq
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CSQSystemUnitTest, SQSystemUnitTest)
{
	CSquirrel sq;
	SQChar path[MAX_PATH];

	std::clog << "squirrel t@Cw" << std::endl;
	std::tcin >> path;

	sq.Open(4096);

	sq.DoFile(path, SQFalse, SQTrue);

	std::clog << std::endl;
}

#endif

#endif
