//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		SqError.cpp
 * @brief		squirrel G[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_SqError_CPP_

//======================================================================
// include
#include "SqError.h"

#ifdef _IRIS_SUPPORT_SQUIRREL

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t

#define _SCSQ_SWITCH_ERROR_MESSAGE(func, text)				\
	switch( Error )											\
	{														\
	case SQ_ERROR:											\
		func(lpBuf, size, text("SQ_ERROR"));				\
		break;												\
	}


namespace iris {
namespace sq
{

//======================================================================
// function
/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
void	SqFormatMessage (SQRESULT Error, LPTSTR lpBuf, size_t size)
{
#ifdef UNICODE
	SqFormatMessageW(Error, lpBuf, size);
#else
	SqFormatMessageA(Error, lpBuf, size);
#endif
}
/** 
 * @ref	SqFormatMessage
*/
void	SqFormatMessageA(SQRESULT Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SCSQ_SWITCH_ERROR_MESSAGE(strcpy_s, TEXTA);
}
/** 
 * @ref	SqFormatMessage
*/
void	SqFormatMessageW(SQRESULT Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	_SCSQ_SWITCH_ERROR_MESSAGE(wcscpy_s, TEXTW);
}

}	// end of namespace sq
}	// end of namespace iris

#endif
