//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PerlSystem.cpp
 * @brief		PerlSystem t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_PerlSystem_CPP_

//======================================================================
// include
#include "PerlSystem.h"

#ifdef _IRIS_SUPPORT_PERL

//======================================================================
// link
#if	defined(IRIS_WIN32)
#pragma comment (lib, "perl512.lib")
#endif

#define my_perl	m_pIntrp

namespace iris {
namespace perl
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPerl::CPerl(void)
: m_pIntrp(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPerl::~CPerl(void)
{
	Terminate();
}

/**********************************************************************//**
 *
 * VXe
 *
 -----------------------------------------------------------------------
 * @param [in]	pargc		= 
 * @param [in]	pargv		= 
*//***********************************************************************/
void CPerl::Initialize(int *pargc, char*** pargv)
{
	PERL_SYS_INIT(pargc, pargv);
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CPerl::Terminate(void)
{
	Delete();
	PERL_SYS_TERM();
}

/**********************************************************************//**
 *
 * C^v^̍쐬
 *
*//***********************************************************************/
bool CPerl::Create(void)
{
	if( m_pIntrp == nullptr )
	{
		m_pIntrp = perl_alloc();
		if( m_pIntrp == nullptr ) return false;
		perl_construct(m_pIntrp);
		PL_exit_flags |= PERL_EXIT_DESTRUCT_END;
	}
	return true;
}

/**********************************************************************//**
 *
 * C^v^̍폜
 *
*//***********************************************************************/
void CPerl::Delete(void)
{
	if( m_pIntrp != nullptr )
	{
		perl_destruct(m_pIntrp);
		perl_free(m_pIntrp);
		m_pIntrp = nullptr;
	}
}

/**********************************************************************//**
 *
 * parser
 *
 -----------------------------------------------------------------------
 * @param [in]	argc		= 
 * @param [in]	argv		= 
 * @param [in]	env			= 
*//***********************************************************************/
void CPerl::Parser(int argc, char** argv, char** env)
{
	perl_parse(m_pIntrp, nullptr, argc, argv, env);
}

/**********************************************************************//**
 *
 * s
 *
*//***********************************************************************/
void CPerl::Run(void)
{
	perl_run(m_pIntrp);
}

}	// end of namespace perl
}	// end of namespace iris

#endif
