//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPUnit.h
 * @brief		PʌnvvZbTt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPUnit_H_
#define INCG_IRIS_PPUnit_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
/// degree -> radian
#define IRIS_Degree2Radian(degree)		(31416 * (degree) / 10000 / 180)
/// pixel -> twip
#define IRIS_Pixel2Twip(pixel, dpi)		((pixel) * 1440 / (dpi))
/// pixel -> point
#define IRIS_Pixel2Point(pixel, dpi)	((pixel) * 72 / (dpi))
/// pixel -> inch
#define IRIS_Pixel2Inch(pixel, dpi)		((pixel) / (dpi))
/// inch -> pixel
#define IRIS_Inch2Pixel(inch, dpi)		((inch) * (dpi))
/// inch -> point
#define IRIS_Inch2Point(inch)			((inch) * 72)
/// inch -> twip
#define IRIS_Inch2Twip(inch)			((inch) * 1440)
/// point -> pixel
#define IRIS_Point2Pixel(point, dpi)	((point) * (dpi) / 72)
/// point -> inch
#define IRIS_Point2Inch(point)			((point) / 72)
/// point -> twip
#define IRIS_Point2Twip(point)			((point) * 20)
/// twip -> pixel
#define IRIS_Twip2Pixel(twip, dpi)		((twip) * (dpi) / 1440)
/// twip -> inch
#define IRIS_Twip2Inch(twip)			((twip) / 1440)
/// twip -> point
#define IRIS_Twip2Point(twip)			((twip) / 20)

/// inch -> mm
#define IRIS_Inch2MilliMeter(inch)		((inch) * 254 / 10)

#endif	// #ifndef _IRIS_PPUnit_H_
