//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPEndian.h
 * @brief		GfBA@vvZbTt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPEndian_H_
#define INCG_IRIS_PPEndian_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
/// GfBA](16bit)
#define IRIS_ReverseEndian16(a)			( ((a)<<8) | ((a)>>8) )
/// GfBA](32bit)
#define IRIS_ReverseEndian32(a)			( ((a)<<24) | (((a)>>8)<<16) | (((a)>>16)<<8) | ((a)>>24) )
/// eGfBAɔ]
#ifdef __BIG_ENDIAN__
#define IRIS_ToLittleEndian32(a)		IRIS_ReverseEndian32(a)
#define IRIS_ToBigEndian32(a)			(a)
#else
#define IRIS_ToLittleEndian32(a)		(a)
#define IRIS_ToBigEndian32(a)			IRIS_ReverseEndian32(a)
#endif

#endif	// #ifndef _IRIS_PPEndian_H_
