//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPColor.h
 * @brief		J[nvvZbTt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPColor_H_
#define INCG_IRIS_PPColor_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
// J[ϊ}N
#define IRIS_ARGB_R(rgba)				(((rgba)>>16)&0xFF)
#define IRIS_ARGB_G(rgba)				(((rgba)>> 8)&0xFF)
#define IRIS_ARGB_B(rgba)				(((rgba)>> 0)&0xFF)
#define IRIS_ARGB_A(rgba)				(((rgba)>>24)&0xFF)

#define IRIS_ARGB(a, r, g, b)			( (((a)&0xFF)<<24) | (((r)&0xFF)<<16) | (((g)&0xFF)<<8) | (((b)&0xFF)) )

#define IRIS_ARGB_ALPHASET(rgba, a)		( ((rgba)&0x00FFFFFF) | (((a)<<24)&0xFF) )

#define IRIS_RGBA_R(rgba)				(((rgba)>>24)&0xFF)
#define IRIS_RGBA_G(rgba)				(((rgba)>>16)&0xFF)
#define IRIS_RGBA_B(rgba)				(((rgba)>> 8)&0xFF)
#define IRIS_RGBA_A(rgba)				(((rgba)>> 0)&0xFF)

#define IRIS_RGBA(r, g, b, a)			( (((r)&0xFF)<<24) | (((g)&0xFF)<<16) | (((b)&0xFF)<<8) | (((a)&0xFF)) )

#define IRIS_RGBA_ALPHASET(rgba, a)		( ((rgba)&0xFFFFFF00) | ((a)&0xFF) )

#endif	// #ifndef _IRIS_PPColor_H_
