//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		PPBitCalc.h
 * @brief		rbgZvvZbT`t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_PPBitCalc_H_
#define INCG_IRIS_PPBitCalc_H_

//======================================================================
// include
#include "PPConfig.h"

//======================================================================
// define
//----------------------------------------
// 
/// z̗vf̎擾
#define IRIS_NumOfElements(a)			(sizeof(a)/sizeof((a)[0]))

//----------------------------------------
//
// tO}N
#define IRIS_FLG32_ON( _flag,_ofs)			((_flag)[ (_ofs)>>5 ] |=  (1 << ((_ofs>>5)&0x1F) ) )
#define IRIS_FLG32_OFF(_flag,_ofs)			((_flag)[ (_ofs)>>5 ] &= ~(1 << ((_ofs>>5)&0x1F) ) )
#define IRIS_FLG32_XOR(_flag,_ofs)			((_flag)[ (_ofs)>>5 ] ^=  (1 << ((_ofs>>5)&0x1F) ) )
#define IRIS_FLG32_CK( _flag,_ofs)			((_flag)[ (_ofs)>>5 ] &   (1 << ((_ofs>>5)&0x1F) ) )
#define IRIS_FLG32_SET(_flag,_ofs,enable)	( enable ? IRIS_FLG32_ON((_flag),(_ofs)) : IRIS_FLG32_OFF((_flag),(_ofs)) )

//----------------------------------------
// 
/// N+1oCgACgɌJグ
#define __IRIS_RoundUpNB(x, n)			(((IrisU32)(IrisU32W64)(x) + (n)) & ~(n))
/// N+1oCgACgɐ؂̂
#define __IRIS_RoundDownNB(x, n)		(((IrisU32)(IrisU32W64)(x)) & ~(n))

/// 4oCgACgɌJグ
#define IRIS_RoundUp4B(x)				__IRIS_RoundUpNB(x, 3)
/// 4oCgACgɐ؂̂
#define IRIS_RoundDown4B(x)				__IRIS_RoundDownNB(x, 3)
/// 16oCgACgɌJグ
#define IRIS_RoundUp16B(x)				__IRIS_RoundUpNB(x, 15)
/// 16oCgACgɐ؂̂
#define IRIS_RoundDown16B(x)			__IRIS_RoundDownNB(x, 15)
/// 32oCgACgɌJグ
#define IRIS_RoundUp32B(x)				__IRIS_RoundUpNB(x, 31)
/// 32oCgACgɐ؂̂
#define IRIS_RoundDown32B(x)			__IRIS_RoundDownNB(x, 31)

/// oϐ̃ItZbgAhX̎擾
#define IRIS_OFFSET(cl, mb)				((IrisS32W64)(&((cl*)0->mb)))

//----------------------------------------
// bit
// WORD
/// bytes to word (b0 = lsb, b1 = msb)
#define IRIS_Bytes2WordLE(b0, b1)			( ((IrisU16)((b0)&0xFF)    ) | ((IrisU16)((b1)&0xFF)<< 8) )
#define IRIS_Bytes2WordBE(b0, b1)			( ((IrisU16)((b1)&0xFF)<< 8) | ((IrisU16)((b0)&0xFF)    ) )
/// bytes to word
#define IRIS_ByteArray2WordLE(a)			( IRIS_Bytes2WordLE((a)[0], (a)[1]) )
#define IRIS_ByteArray2WordBE(a)			( IRIS_Bytes2WordBE((a)[0], (a)[1]) )
/// word to byte(lsb)
#define IRIS_Word2LSByteLE(w, n)			( (IrisU8)((w) >> (n<<3)) )
#define IRIS_Word2LSByteBE(w, n)			( (IrisU8)((w) >> ((n^1)<<3)) )
/// word to byte(msb)
#define IRIS_Word2MSByteLE(w, n)			IRIS_Word2LSByteBE(w, n)
#define IRIS_Word2MSByteBE(w, n)			IRIS_Word2LSByteLE(w, n)
/// word to byte(msb)
#define IRIS_Word2ByteLE(w, n)				IRIS_Word2LSByteLE(w, n)
#define IRIS_Word2ByteBE(w, n)				IRIS_Word2LSByteBE(w, n)
#ifdef __BIG_ENDIAN__
#  define IRIS_Bytes2Word					IRIS_Bytes2WordBE
#  define IRIS_ByteArray2Word				IRIS_ByteArray2WordBE
#  define IRIS_Word2LSByte					IRIS_Word2LSByteBE
#  define IRIS_Word2MSByte					IRIS_Word2MSByteBE
#else
#  define IRIS_Bytes2Word					IRIS_Bytes2WordLE
#  define IRIS_ByteArray2Word				IRIS_ByteArray2WordLE
#  define IRIS_Word2LSByte					IRIS_Word2LSByteLE
#  define IRIS_Word2MSByte					IRIS_Word2MSByteLE
#endif

// DWORD
/// bytes to dword (b0 = lsb, b3 = msb)
#define IRIS_Bytes2DWordLE(b0, b1, b2, b3)	( ((IrisU32)((b0)&0xFF)    ) | ((IrisU32)((b1)&0xFF)<< 8) | ((IrisU32)((b2)&0xFF)<<16) | ((IrisU32)((b3)&0xFF)<<24) )
#define IRIS_Bytes2DWordBE(b0, b1, b2, b3)	( ((IrisU32)((b0)&0xFF)<<24) | ((IrisU32)((b1)&0xFF)<<16) | ((IrisU32)((b2)&0xFF)<< 8) | ((IrisU32)((b3)&0xFF)    ) )
/// bytes to dword
#define IRIS_ByteArray2DWordLE(a)			( IRIS_Bytes2DWordLE((a)[0], (a)[1], (a)[2], (a)[3]) )
#define IRIS_ByteArray2DWordBE(a)			( IRIS_Bytes2DWordBE((a)[0], (a)[1], (a)[2], (a)[3]) )
/// dword to byte(lsb)
#define IRIS_DWord2LSByteLE(w, n)			( (IrisU8)((w) >> (n<<3)) )
#define IRIS_DWord2LSByteBE(w, n)			( (IrisU8)((w) >> ((n^3)<<3)) )
/// dword to byte(msb)
#define IRIS_DWord2MSByteLE(w, n)			IRIS_DWord2LSByteBE(w, n)
#define IRIS_DWord2MSByteBE(w, n)			IRIS_DWord2LSByteLE(w, n)
/// dword to byte
#define IRIS_DWord2ByteLE(w, n)				IRIS_DWord2LSByteLE(w, n)
#define IRIS_DWord2ByteBE(w, n)				IRIS_DWord2LSByteBE(w, n)
#ifdef __BIG_ENDIAN__
#  define IRIS_Bytes2DWord					IRIS_Bytes2DWordBE
#  define IRIS_ByteArray2DWord				IRIS_ByteArray2DWordBE
#  define IRIS_DWord2LSByte					IRIS_DWord2LSByteBE
#  define IRIS_DWord2MSByte					IRIS_DWord2MSByteBE
#  define IRIS_DWord2Byte					IRIS_DWord2LSByteBE
#else
#  define IRIS_Bytes2DWord					IRIS_Bytes2DWordLE
#  define IRIS_ByteArray2DWord				IRIS_ByteArray2DWordLE
#  define IRIS_DWord2LSByte					IRIS_DWord2LSByteLE
#  define IRIS_DWord2MSByte					IRIS_DWord2MSByteLE
#  define IRIS_DWord2Byte					IRIS_DWord2LSByteLE
#endif

// QWORD
/// bytes to qword (b0 = lsb, b7 = msb)
#define IRIS_Bytes2QWordLE(b0, b1, b2, b3, b4, b5, b6, b7)	\
	( ((IrisU64)((b0)&0xFF)    ) | ((IrisU64)((b1)&0xFF)<< 8) | ((IrisU64)((b2)&0xFF)<<16) | ((IrisU64)((b3)&0xFF)<<24) ) | \
	( ((IrisU64)((b4)&0xFF)<<32) | ((IrisU64)((b5)&0xFF)<<40) | ((IrisU64)((b6)&0xFF)<<48) | ((IrisU64)((b7)&0xFF)<<56) )

#define IRIS_Bytes2QWordBE(b0, b1, b2, b3, b4, b5, b6, b7)	\
	( ((IrisU64)((b0)&0xFF)<<56) | ((IrisU64)((b1)&0xFF)<<48) | ((IrisU64)((b2)&0xFF)<<40) | ((IrisU64)((b3)&0xFF)<<32) ) | \
	( ((IrisU64)((b4)&0xFF)<<24) | ((IrisU64)((b5)&0xFF)<<16) | ((IrisU64)((b6)&0xFF)<< 8) | ((IrisU64)((b7)&0xFF)    ) )
/// bytes to qword
#define IRIS_ByteArray2QWordLE(a)			( IRIS_Bytes2QWordLE((a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5], (a)[6], (a)[7]) )
#define IRIS_ByteArray2QWordBE(a)			( IRIS_Bytes2QWordBE((a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5], (a)[6], (a)[7]) )
/// qword to byte(lsb)
#define IRIS_QWord2LSByteLE(w, n)			( (IrisU8)((w) >> (n<<3)) )
#define IRIS_QWord2LSByteBE(w, n)			( (IrisU8)((w) >> ((n^7)<<3)) )
/// qword to byte(msb)
#define IRIS_QWord2MSByteLE(w, n)			IRIS_QWord2LSByteBE(w, n)
#define IRIS_QWord2MSByteBE(w, n)			IRIS_QWord2LSByteLE(w, n)
/// qword to byte(msb)
#define IRIS_QWord2ByteLE(w, n)				IRIS_QWord2LSByteLE(w, n)
#define IRIS_QWord2ByteBE(w, n)				IRIS_QWord2LSByteBE(w, n)
#ifdef __BIG_ENDIAN__
#  define IRIS_Bytes2QWord					IRIS_Bytes2QWordBE
#  define IRIS_ByteArray2QWord				IRIS_ByteArray2QWordBE
#  define IRIS_QWord2LSByte					IRIS_QWord2LSByteBE
#  define IRIS_QWord2MSByte					IRIS_QWord2MSByteBE
#  define IRIS_QWord2Byte					IRIS_QWord2ByteBE
#else
#  define IRIS_Bytes2QWord					IRIS_Bytes2QWordLE
#  define IRIS_ByteArray2QWord				IRIS_ByteArray2QWordLE
#  define IRIS_QWord2LSByte					IRIS_QWord2LSByteLE
#  define IRIS_QWord2MSByte					IRIS_QWord2MSByteLE
#  define IRIS_QWord2Byte					IRIS_QWord2LSByteLE
#endif

/// nrbg]
#define IRIS_rotl(x, n)					( ((x) << ((n) & ((sizeof(x)<<3)-1))) | ((x) >> ((sizeof(x)<<3) - ((n) & ((sizeof(x)<<3)-1)))) )
#define IRIS_rotl32(x, n)				( ((x) << ((n) & 31)) | ((x) >> (32 - ((n) & 31))) )
/// Enrbg]
#define IRIS_rotr(x, n)					( ((x) >> ((n) & ((sizeof(x)<<3)-1))) | ((x) << ((sizeof(x)<<3) - ((n) & ((sizeof(x)<<3)-1)))) )
#define IRIS_rotr32(x, n)				( ((x) >> ((n) & 31)) | ((x) << (32 - ((n) & 31))) )

/// 4cc (Big Endian) (c0 = msb, c3 = lsb)
#define IRIS_FOURCC_BE(c0, c1, c2, c3)	IRIS_Bytes2DWordBE(c3, c2, c1, c0)
/// 4cc (Little Endian) (c0 = msb, c3 = lsb)
#define IRIS_FOURCC_LE(c0, c1, c2, c3)	IRIS_Bytes2DWordLE(c3, c2, c1, c0)
/// 4cc
#ifdef __BIG_ENDIAN__
#define IRIS_FOURCC(c0, c1, c2, c3)		IRIS_FOURCC_BE(c0, c1, c2, c3)
#else
#define IRIS_FOURCC(c0, c1, c2, c3)		IRIS_FOURCC_LE(c0, c1, c2, c3)
#endif

/// ŏʃrbg}XN
#define IRIS_MSB_MASK(x)				(0x1 << ((sizeof(x)<<3)-1))

#endif	// #ifndef _IRIS_PPBitCalc_H_
