//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMSXMLNode.cpp
 * @brief		MSXML Node t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMSXMLNode_CPP_

//======================================================================
// include
#include "WXMSXMLNode.h"
#include <tchar.h>

#include "iris_debug.h"

#ifdef _IRIS_SUPPORT_MSXML

//======================================================================
// define

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMSXmlNode::CMSXmlNode(INodePtr node)
: m_Node(node)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMSXmlNode::~CMSXmlNode(void)
{
}

/**********************************************************************//**
 *
 * qm[h̒ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszNodeName	= m[h
 * @param [in]	lpszText		= m[heLXg
 * @return	ǉꂽm[h
*//***********************************************************************/
CMSXmlNode::INodePtr CMSXmlNode::AddChild(LPCTSTR lpszNodeName, LPCTSTR lpszText)
{
	INodePtr node;
	if( m_Node != nullptr )
	{
		IDocumentPtr doc;
		if( FAILED(m_Node->get_ownerDocument(&doc)) ) return node;
		node = doc->createElement(lpszNodeName);
		if( node != nullptr )
		{
			m_Node->appendChild(node);
			node->text = lpszText;
		}
	}
	return node;
}

/**********************************************************************//**
 *
 * qm[h̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszNodeName	= m[h
 * @return	
*//***********************************************************************/
BOOL CMSXmlNode::RemoveChild(LPCTSTR lpszNodeName)
{
	INodePtr node = GetChild(lpszNodeName);
	return RemoveChild(node);
}

/**********************************************************************//**
 *
 * qm[h̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	node	= m[h
 * @return	
*//***********************************************************************/
BOOL CMSXmlNode::RemoveChild(INodePtr node)
{
	IRIS_ASSERT( m_Node != nullptr );
	if( m_Node->removeChild(node) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * qm[h̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszNodeName	= m[h
 * @return	m[h
*//***********************************************************************/
CMSXmlNode::INodePtr CMSXmlNode::GetChild(LPCTSTR lpszNodeName)
{
	IRIS_ASSERT( m_Node != nullptr );
	INodeListPtr childs = m_Node->childNodes;
	for( int i=0; i < childs->length; ++i )
	{
		INodePtr node = childs->item[i];
		if( _tcscmp(lpszNodeName, (LPCTSTR)node->nodeName) == 0 ) return node;
	}
	return NULL;
}

/**********************************************************************//**
 *
 * qm[h̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszNodeName	= m[hCfbNX
 * @return	m[h
*//***********************************************************************/
CMSXmlNode::INodePtr CMSXmlNode::GetChild(INT nIndex)
{
	IRIS_ASSERT( m_Node != nullptr );
	INodeListPtr childs = m_Node->childNodes;
	IRIS_ASSERT( nIndex >= 0 && nIndex < childs->length );
	return childs->item[nIndex];
}

/**********************************************************************//**
 *
 * ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszAttribute	= 
 * @param [in]	lpszValue		= ̒l
 * @return	
*//***********************************************************************/
BOOL CMSXmlNode::SetAttribute(LPCTSTR lpszAttribute, LPCTSTR lpszValue)
{
	IAttributePtr attr;
	if( m_Node != nullptr )
	{
		IDocumentPtr doc;
		if( FAILED(m_Node->get_ownerDocument(&doc)) ) return FALSE;
		attr = doc->createAttribute(lpszAttribute);
		if( attr != nullptr )
		{
			if( m_Node->attributes->setNamedItem(attr) != nullptr )
			{
				attr->value = lpszValue;
				return TRUE;
			}
		}
	}
	return FALSE;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszAttribute	= 
 * @param [in]	lpszDefault		= ̃ftHgl
 * @param [out]	lpszValue		= ̒l
 * @param [in]	dwSize			= o̓obt@
 * @return	
*//***********************************************************************/
BOOL CMSXmlNode::GetAttribute(LPCTSTR lpszAttribute, LPCTSTR lpszDefault, LPTSTR lpszValue, DWORD dwSize)
{
	IRIS_ASSERT( lpszValue != nullptr );
	if( m_Node != nullptr )
	{
		MSXML2::IXMLDOMNamedNodeMapPtr attributes = m_Node->Getattributes();
		if( attributes != nullptr )
		{
			INodePtr node = attributes->getNamedItem(lpszAttribute);
			if( node != nullptr )
			{
				_tcscpy_s(lpszValue, dwSize, (LPCTSTR)(node->text));
			}
		}
	}
	_tcscpy_s(lpszValue, dwSize, lpszDefault);
	return FALSE;
}

}	// end of namespace wx
}	// end of namespace iris

#endif
