//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMSXML.h
 * @brief		WXMSXML t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMSXML_H_
#define INCG_IRIS_WXMSXML_H_

//======================================================================
// include
#include "iris_object.h"

#ifdef _IRIS_SUPPORT_MSXML

#include "msxml3.tlh"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	MS XML p[T[NX
*/
class CMSXml : public IIrisObject
{
public:
	typedef MSXML2::IXMLDOMDocumentPtr	IDocumentPtr;
	typedef MSXML2::IXMLDOMNodePtr		INodePtr;
	typedef MSXML2::IXMLDOMNodeListPtr	INodeListPtr;
	typedef MSXML2::IXMLDOMElementPtr	IElementPtr;
	typedef MSXML2::IXMLDOMAttributePtr	IAttributePtr;

private:
	IDocumentPtr	m_Doc;	//!< hLg
public:
	// RXgN^
	CMSXml(void);
	// fXgN^
	~CMSXml(void);

public:
	// 쐬
	bool	Create(void);
	// 
	void	Close(void);

public:
	// 񂩂ǂݍ
	bool	LoadFromString(LPCTSTR lpszXml);
	// t@Cǂݍ
	bool	LoadFromFile(LPCTSTR lpszFileName);
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
