//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHFileSave.cpp
 * @brief		t@Cۑ_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHFileSave_CPP_

//======================================================================
// include
#include "WXSHFileSave.h"
#include <shlobj.h>

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [in]	lpszTitle		= EBhE^Cg
 * @param [in]	lpszFilter		= tB^[
 * @param [in]	lpszDefExt		= ftHggq
 * @param [out]	lpszFolderName	= tH_̃tpX(߂l)
 * @param [in]	dwSize			= lpszFolderName TCY
 * @param [in]	Flags			= _CAÕtO
 * @param [in]	lpofn			= 
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
BOOL CSHFileSave::ShowA(HWND hWnd, LPCSTR  lpszTitle, LPCSTR  lpszFilter, LPCSTR  lpszDefExt
						, LPSTR  lpszFileName, DWORD dwSize, DWORD Flags, LPOPENFILENAMEA lpofn)
{
	OPENFILENAMEA ofn = {0};
	if( lpofn == nullptr ) 
	{
		lpofn = &ofn;
	}

	lpofn->lStructSize		= sizeof(OPENFILENAMEA); 
	lpofn->hwndOwner		= hWnd;
	lpofn->lpstrFilter		= lpszFilter;
	lpofn->lpstrFile		= lpszFileName;
	lpofn->nMaxFile			= dwSize;
	lpofn->Flags			= Flags;
	lpofn->lpstrDefExt		= lpszDefExt;
	lpofn->lpstrTitle		= lpszTitle;
	return (GetSaveFileNameA(lpofn));
}
BOOL CSHFileSave::ShowW(HWND hWnd, LPCWSTR lpszTitle, LPCWSTR lpszFilter, LPCWSTR lpszDefExt
						, LPWSTR lpszFileName, DWORD dwSize, DWORD Flags, LPOPENFILENAMEW lpofn)
{
	OPENFILENAMEW ofn = {0};
	if( lpofn == nullptr ) 
	{
		lpofn = &ofn;
	}

	lpofn->lStructSize		= sizeof(OPENFILENAMEW); 
	lpofn->hwndOwner		= hWnd;
	lpofn->lpstrFilter		= lpszFilter;
	lpofn->lpstrFile		= lpszFileName;
	lpofn->nMaxFile			= dwSize;
	lpofn->Flags			= Flags;
	lpofn->lpstrDefExt		= lpszDefExt;
	lpofn->lpstrTitle		= lpszTitle;
	return (GetSaveFileNameW(lpofn));
}

}	// end of namespace wx
}	// end of namespace iris

