//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseFont.cpp
 * @brief		tHgI_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHChooseFont_CPP_

//======================================================================
// include
#include "WXSHChooseFont.h"
#include "iris_debug.h"
#include <shlobj.h>

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * tHgI_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hOwner			= eEChẼnh
 * @param [out]	lpLogFont		= tHg(߂l)
 * @param [in]	SizeMin			= ŏtHgTCY
 * @param [in]	SizeMax			= őtHgTCY
 * @param [in]	Flags			= ݒtO
 * @param [out]	pColor			= tHgJ[(߂l)
 * @param [out]	lpPointSize		= tHgTCY(߂l)
 * @param [in]	lpTemplateName	= _CAOev[g
 * @param [in]	hInstance		= _CAOev[gi[nh
 * @param [in]	lpfnHook		= 
 * @param [in]	lCustData		= 
 * @retval	TRUE = Iꍇ
*//***********************************************************************/
BOOL CSHChooseFont::ShowA(HWND hOwner, LPLOGFONTA lpLogFont, int SizeMin, int SizeMax, DWORD Flags, LPCOLORREF pColor, LPINT lpPointSize
						  , LPCSTR  lpTemplateName, HINSTANCE hInstance, LPCCHOOKPROC lpfnHook, LPARAM lCustData)
{
#if	!defined(IRIS_WIN32_WCE)
	CHOOSEFONTA cf;
	memset(&cf, 0, sizeof(cf));
	COLORREF ColorTemp=0x00000000;
	if( pColor == nullptr ) pColor = &ColorTemp;

	cf.lStructSize = sizeof(CHOOSEFONTA);
	cf.hwndOwner = hOwner;
	cf.lpLogFont = lpLogFont;
	cf.nSizeMin = SizeMin;
	cf.nSizeMax = SizeMax;
	cf.Flags = Flags;
	cf.rgbColors = *pColor;

	cf.hInstance = hInstance;
	cf.lpTemplateName = lpTemplateName;
	cf.lpfnHook = lpfnHook;
	cf.lCustData = lCustData;

	if(!ChooseFontA(&cf)) return FALSE;

	*pColor = cf.rgbColors;
	if( lpPointSize != nullptr ) *lpPointSize = cf.iPointSize;
	return TRUE;
#else
	return FALSE;
#endif
}
BOOL CSHChooseFont::ShowW(HWND hOwner, LPLOGFONTW lpLogFont, int SizeMin, int SizeMax, DWORD Flags, LPCOLORREF pColor, LPINT lpPointSize
						  , LPCWSTR lpTemplateName, HINSTANCE hInstance, LPCCHOOKPROC lpfnHook, LPARAM lCustData)
{
#if	!defined(IRIS_WIN32_WCE)
	CHOOSEFONTW cf;
	memset(&cf, 0, sizeof(cf));
	COLORREF ColorTemp=0x00000000;
	if( pColor == nullptr ) pColor = &ColorTemp;

	cf.lStructSize = sizeof(CHOOSEFONTW);
	cf.hwndOwner = hOwner;
	cf.lpLogFont = lpLogFont;
	cf.nSizeMin = SizeMin;
	cf.nSizeMax = SizeMax;
	cf.Flags = Flags;
	cf.rgbColors = *pColor;

	cf.hInstance = hInstance;
	cf.lpTemplateName = lpTemplateName;
	cf.lpfnHook = lpfnHook;
	cf.lCustData = lCustData;

	if(!ChooseFontW(&cf)) return FALSE;

	*pColor = cf.rgbColors;
	if( lpPointSize != nullptr ) *lpPointSize = cf.iPointSize;
	return TRUE;
#else
	return FALSE;
#endif
}

}	// end of namespace wx
}	// end of namespace iris

