//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseColor.h
 * @brief		J[I_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHChooseColor_H_
#define INCG_IRIS_WXSHChooseColor_H_

//======================================================================
// include
#include "iris_object.h"
#include <commdlg.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	J[I_CAONX
*/
class CSHChooseColor : public IIrisObject
{
private:

public:
	// J
	static	BOOL	ShowA(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
		, LPCSTR  lpTemplateName=nullptr, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0);
	static	BOOL	ShowW(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
		, LPCWSTR lpTemplateName=nullptr, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0);

	/**
	 * @name	J
	 * @{
	*/
	static	BOOL	Show(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
		, LPCSTR  lpTemplateName, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0)	
	{ return ShowA(hOwner, pResult, pCustColors, Flags, lpTemplateName, hInstance, lpfnHook, lCustData); }
	static	BOOL	Show(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
		, LPCWSTR lpTemplateName, HINSTANCE hInstance=nullptr, LPCCHOOKPROC lpfnHook=nullptr, LPARAM lCustData=0)	
	{ return ShowW(hOwner, pResult, pCustColors, Flags, lpTemplateName, hInstance, lpfnHook, lCustData); }
	static	BOOL	Show(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags)	
	{
#ifdef UNICODE
		return ShowW(hOwner, pResult, pCustColors, Flags);
#else
		return ShowA(hOwner, pResult, pCustColors, Flags);
#endif
	}
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
