//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHChooseColor.cpp
 * @brief		J[I_CAONX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHChooseColor_CPP_

//======================================================================
// include
#include "WXSHChooseColor.h"
#include "iris_debug.h"
#include <shlobj.h>

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * J[I_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd			= eEChẼnh
 * @param [out]	pResult			= o̓J[
 * @param [in]	pCustColors		= JX^J[z
 * @param [in]	Flags			= _CAÕtO
 * @param [in]	lpTemplateName	= _CAOev[g
 * @param [in]	hInstance		= _CAOev[gi[nh
 * @param [in]	lpfnHook		= 
 * @param [in]	lCustData		= 
 * @retval	TRUE = tH_Iꍇ
*//***********************************************************************/
BOOL CSHChooseColor::ShowA(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
						  , LPCSTR  lpTemplateName, HINSTANCE hInstance, LPCCHOOKPROC lpfnHook, LPARAM lCustData)
{
	IRIS_ASSERT(pResult != nullptr);
	CHOOSECOLORA cc;
	memset(&cc, 0, sizeof(CHOOSECOLORA));
	cc.lStructSize = sizeof(CHOOSECOLORA);
	cc.hwndOwner = hOwner;
	cc.rgbResult = *pResult;
	cc.lpCustColors = pCustColors;
	cc.Flags = Flags;

#if	!defined(IRIS_WIN32_WCE) && STRICT
	cc.hInstance = reinterpret_cast<HWND>(hInstance);
#else
	cc.hInstance = hInstance;
#endif

#if	!defined(IRIS_WIN32_WCE) || !defined(UNICODE)
	cc.lpTemplateName = lpTemplateName;
#else
	WCHAR temp[256];
	if( lpTemplateName != nullptr )
	{
		mbstowcs(temp, lpTemplateName, 256);
		cc.lpTemplateName = temp;
	}
#endif
	cc.lpfnHook = lpfnHook;
	cc.lCustData = lCustData;
	if( pCustColors == nullptr )
	{
		COLORREF def[16];
		cc.lpCustColors = def;
		if( !ChooseColorA(&cc) ) return FALSE;
	}
	else
	{
		if( !ChooseColorA(&cc) ) return FALSE;
	}
	*pResult = cc.rgbResult;
	return TRUE;
}
BOOL CSHChooseColor::ShowW(HWND hOwner, LPCOLORREF pResult, LPCOLORREF pCustColors, DWORD Flags
						  , LPCWSTR lpTemplateName, HINSTANCE hInstance, LPCCHOOKPROC lpfnHook, LPARAM lCustData)
{
	IRIS_ASSERT(pResult != nullptr);
	CHOOSECOLORW cc;
	memset(&cc, 0, sizeof(CHOOSECOLORW));
	cc.lStructSize = sizeof(CHOOSECOLORW);
	cc.hwndOwner = hOwner;
	cc.rgbResult = *pResult;
	cc.lpCustColors = pCustColors;
	cc.Flags = Flags;

#if	!defined(IRIS_WIN32_WCE) && STRICT
	cc.hInstance = reinterpret_cast<HWND>(hInstance);
#else
	cc.hInstance = hInstance;
#endif

#if	!defined(IRIS_WIN32_WCE) || defined(UNICODE)
	cc.lpTemplateName = lpTemplateName;
#else
	CHAR temp[256];
	if( lpTemplateName != nullptr )
	{
		wcstombs(temp, lpTemplateName, 256);
		cc.lpTemplateName = temp;
	}
#endif
	cc.lpfnHook = lpfnHook;
	cc.lCustData = lCustData;
	if( pCustColors == nullptr )
	{
		COLORREF def[16];
		cc.lpCustColors = def;
		if( !ChooseColorW(&cc) ) return FALSE;
	}
	else
	{
		if( !ChooseColorW(&cc) ) return FALSE;
	}
	*pResult = cc.rgbResult;
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

