//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHAbout.h
 * @brief		ShellAbout NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHAbout_H_
#define INCG_IRIS_WXSHAbout_H_

//======================================================================
// include
#include "../../resource/WXVersionInfo.h"

namespace iris {
namespace wx
{

//======================================================================
// enum
//!< o[W_CAO̕\eLXg̃tOCfbNX
typedef enum VERSIONDLG_ID
{
	  VERDLG_ID_COMPANYNAME		= CVersionInfo::COMPANYNAME		//!< Ж
	, VERDLG_ID_FILEDESCRIPTION	= CVersionInfo::FILEDESCRIPTION	//!< 
	, VERDLG_ID_FILEVERSION		= CVersionInfo::FILEVERSION		//!< t@Co[W
	, VERDLG_ID_INTERNALNAME	= CVersionInfo::INTERNALNAME		//!< 
	, VERDLG_ID_LEGALCOPYRIGHT	= CVersionInfo::LEGALCOPYRIGHT		//!< 쌠
	, VERDLG_ID_ORIGINALFILENAME= CVersionInfo::ORIGINALFILENAME	//!< t@C
	, VERDLG_ID_PRODUCTNAME		= CVersionInfo::PRODUCTNAME		//!< i
	, VERDLG_ID_PRODUCTVERSION	= CVersionInfo::PRODUCTVERSION		//!< io[W
	, VERDLG_ID_COMMENTS		= CVersionInfo::COMMENTS			//!< Rg
	, VERDLG_ID_LEGALTRADEMARKS	= CVersionInfo::LEGALTRADEMARKS	//!< W
	, VERDLG_ID_PRIVATEBUILD	= CVersionInfo::PRIVATEBUILD		//!< vCx[grh
	, VERDLG_ID_SPECIALBUILD	= CVersionInfo::SPECIALBUILD		//!< XyVrh

	, VERDLG_ID_SEPARATOR		= CVersionInfo::TERM			//!< ؂
	, VERDLG_ID_RETURN											//!< s
	, VERDLG_ID_TERM			= -1
} VERSIONDLG_ID;

//!< o[W_CAO̕\eLXg̃tO
typedef enum VERSIONDLG_MASK
{
	  VERDLG_MASK_COMPANYNAME		= 1<<VERDLG_ID_COMPANYNAME			//!< Ж
	, VERDLG_MASK_FILEDESCRIPTION	= 1<<VERDLG_ID_FILEDESCRIPTION		//!< 
	, VERDLG_MASK_FILEVERSION		= 1<<VERDLG_ID_FILEVERSION			//!< t@Co[W
	, VERDLG_MASK_INTERNALNAME		= 1<<VERDLG_ID_INTERNALNAME			//!< 
	, VERDLG_MASK_LEGALCOPYRIGHT	= 1<<VERDLG_ID_LEGALCOPYRIGHT		//!< 쌠
	, VERDLG_MASK_ORIGINALFILENAME	= 1<<VERDLG_ID_ORIGINALFILENAME		//!< t@C
	, VERDLG_MASK_PRODUCTNAME		= 1<<VERDLG_ID_PRODUCTNAME			//!< i
	, VERDLG_MASK_PRODUCTVERSION	= 1<<VERDLG_ID_PRODUCTVERSION		//!< io[W
	, VERDLG_MASK_COMMENTS			= 1<<VERDLG_ID_COMMENTS				//!< Rg
	, VERDLG_MASK_LEGALTRADEMARKS	= 1<<VERDLG_ID_LEGALTRADEMARKS		//!< W
	, VERDLG_MASK_PRIVATEBUILD		= 1<<VERDLG_ID_PRIVATEBUILD			//!< vCx[grh
	, VERDLG_MASK_SPECIALBUILD		= 1<<VERDLG_ID_SPECIALBUILD			//!< XyVrh
	, VERDLG_MASK_SEPARATOR			= 1<<VERDLG_ID_SEPARATOR			//!< ؂
	, VERDLG_MASK_RETURN			= 1<<VERDLG_ID_RETURN				//!< s
	, VERDLG_MASK_DEFAULT			= VERDLG_MASK_COMPANYNAME
									| VERDLG_MASK_FILEDESCRIPTION
									| VERDLG_MASK_FILEVERSION
									| VERDLG_MASK_LEGALCOPYRIGHT
									| VERDLG_MASK_ORIGINALFILENAME
	, VERDLG_MASK_ALL				= 0x7FFFFFFF						//!< ׂ
	, VERDLG_MASK_TERM				= VERDLG_ID_TERM

} VERSIONDLG_MASK;

//======================================================================
// class
/**
 * @brief	tH_I_CAONX
*/
class CSHAbout : public IIrisObject
{
private:

public:
	// J
	static	INT	ShowA(HWND hParent, LPCSTR  AppName, LPCSTR  Comment, HICON hIcon);
	static	INT	ShowW(HWND hParent, LPCWSTR AppName, LPCWSTR Comment, HICON hIcon);

	// VERSIONINFO Wĕ\
	static	INT	ShowFromVersionInfo(HWND hParent, int nMask, HICON hIcon);
	static	INT	ShowFromVersionInfoEx(HWND hParent, int id_table[], HICON hIcon);

	/**
	 * @name	J
	 * @{
	*/
	static	INT	Show(HWND hParent, LPCSTR  AppName, LPCSTR  Comment, HICON hIcon)	
	{ return ShowA(hParent, AppName, Comment, hIcon); }
	static	INT	Show(HWND hParent, LPCWSTR AppName, LPCWSTR Comment, HICON hIcon)	
	{ return ShowW(hParent, AppName, Comment, hIcon); }
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
