//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellPath.cxx
 * @brief		pXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifdef INCG_IRIS_WXShellPath_CPP_

#define INCG_IRIS_WXShellPath_CXX_

#if		defined(_POSTFIX) && defined(_XCHAR) && defined(_XUCHAR) && defined(_TCSFUNCNAME) && defined(_XT)

#include "preprocessor/PPString.h"

#define _LPXSTR		_XCHAR *
#define _LPCXSTR	const _XCHAR *

#define _CLASSNAME	IRIS_PP_CAT(CPath, _POSTFIX)
#define __FUNCTION(name)	IRIS_PP_CAT(Path, name)
#define _FUNCTION(name)		__FUNCTION(IRIS_PP_CAT(name, _POSTFIX))

#define xcscpy_s	IRIS_PP_CAT(_TCSFUNCNAME, cpy_s)
#define xcscat_s	IRIS_PP_CAT(_TCSFUNCNAME, cat_s)

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
_CLASSNAME::_CLASSNAME(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
_CLASSNAME::_CLASSNAME(_LPCXSTR  lpszPath)
{
	Copy(lpszPath);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
_CLASSNAME::~_CLASSNAME(void)
{
}

/**********************************************************************//**
 *
 * operator
 *
*//***********************************************************************/
//! []
_XCHAR _CLASSNAME::operator [] (int nIndex) const
{
	return m_Path[nIndex];
}
//! _tcscpy
_CLASSNAME& _CLASSNAME::operator = (_LPCXSTR  lpString)
{
	Copy(lpString);
	return *this;
}
//! _tcscat
_CLASSNAME& _CLASSNAME::operator += (_LPCXSTR  lpString)
{
	xcscat_s(m_Path, MAX_PATH, lpString);
	return *this;
}

/**********************************************************************//**
 *
 * Rs[
 *
*//***********************************************************************/
void _CLASSNAME::Copy(_LPCXSTR  lpszPath)
{
	xcscpy_s(m_Path, MAX_PATH, lpszPath);
}

/**********************************************************************//**
 *
 * obNXbVǉ
 *
 ----------------------------------------------------------------------
 * @return	g
*//***********************************************************************/
_CLASSNAME& _CLASSNAME::AddBackslash(void)
{
	_FUNCTION(AddBackslash)(m_Path);
	return *this;
}

/**********************************************************************//**
 *
 * gqǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::AddExtension(_LPCXSTR  pszExt)
{
	return _FUNCTION(AddExtension)(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * t@Cǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::AddFileName(_LPCXSTR  pszFile)
{
	return CombineFile(pszFile);
}

/**********************************************************************//**
 *
 * pX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	pszMore	= 镶
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::Append(_LPCXSTR  pszMore)
{
	return _FUNCTION(Append)(m_Path, pszMore);
}

/**********************************************************************//**
 *
 * hCu[gpX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	iDrive	= hCuԍ
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::BuildRoot(int iDrive)
{
	if( _FUNCTION(BuildRoot)(m_Path, iDrive) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::Canonicalize(void)
{
	return _FUNCTION(Canonicalize)(m_Path, m_Path);
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= ̓pX
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::Canonicalize(_LPCXSTR  pszPath)
{
	return _FUNCTION(Canonicalize)(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * fBNgpXƃt@Č
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::Combine(_LPCXSTR  pszDir, _LPCXSTR  pszFile)
{
	if( _FUNCTION(Combine)(m_Path, pszDir, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * fBNgpXƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CombineDirectory(_LPCXSTR  pszDir)
{
	if( _FUNCTION(Combine)(m_Path, pszDir, m_Path) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * t@Cƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CombineFile(_LPCXSTR  pszFile)
{
	if( _FUNCTION(Combine)(m_Path, m_Path, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * \̈Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC		= tHgێĂfoCXReLXg
 * @param [in]	dx		= \
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CompactPath(HDC hDC, int dx)
{
	return _FUNCTION(CompactPath)(hDC, m_Path, dx);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CompactPathEx(UINT cchMax, DWORD dwFlags)
{
	return _FUNCTION(CompactPathEx)(m_Path, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDst		= o̓obt@
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CompactPathEx(_LPXSTR  pszDst, UINT cchMax, DWORD dwFlags)
{
	return _FUNCTION(CompactPathEx)(pszDst, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Q̃pX狤ʂ̃pXo
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile1	= pXP
 * @param [in]	pszFile2	= pXQ
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::CommonPrefix(_LPCXSTR  pszFile1, _LPCXSTR  pszFile2)
{
	return _FUNCTION(CommonPrefix)(pszFile1, pszFile2, m_Path);
}

/**********************************************************************//**
 *
 * pXWJpXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc	= ϊ
 * @return	񂾃TCY
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
DWORD _CLASSNAME::ExpandEnvStrings(_LPCXSTR  lpSrc)
{
	return IRIS_PP_CAT(ExpandEnvironment, IRIS_PP_CAT(Strings, _POSTFIX))(lpSrc, m_Path, MAX_PATH);
}
#endif

/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL _CLASSNAME::FileExists(void)
{
	return _FUNCTION(FileExists)(m_Path);
}

/**********************************************************************//**
 *
 * gq
 *
 ----------------------------------------------------------------------
 * @return	gqւ̃|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::FindExtension(void)
{
	return _FUNCTION(FindExtension)(m_Path);
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @return	t@Cւ̃|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::FindFileName(void)
{
	return _FUNCTION(FindFileName)(m_Path);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::FindNextComponent(void)
{
	return _FUNCTION(FindNextComponent)(m_Path);
}

/**********************************************************************//**
 *
 * Ō̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::FindLastComponent(void)
{
	_LPXSTR  ret = nullptr;
	_LPXSTR  next = nullptr;
	next = FindNextComponent();
	while(next && *next != '\0' )
	{
		ret = next;
		next = FindNextComponent(next);
	}
	return ret;
}

/**********************************************************************//**
 *
 * WpXEst@C
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= pXiʂ̊i[obt@j
 * @return	ppszOtherDirs	= ΏۃpXXg
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::FindOnPath(_LPXSTR  pszPath, _LPCXSTR * ppszOtherDirs)
{
	if( !_FUNCTION(FindOnPath)(pszPath, ppszOtherDirs) ) return FALSE;
	xcscpy_s(m_Path, MAX_PATH, pszPath);
	return TRUE;
}

/**********************************************************************//**
 *
 * TtBbNX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	lppSuffix	= TtBbNXXg
 * @return	nArraySize	= lppSuffix̔z
 * @return	v̐擪|C^BsƂnullptr
*//***********************************************************************/
_LPCXSTR  _CLASSNAME::FindSuffixArray(_LPCXSTR * lppSuffix, int nArraySize)
{
	return _FUNCTION(FindSuffixArray)(m_Path, lppSuffix, nArraySize);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::GetArgs(void)
{
	return _FUNCTION(GetArgs)(m_Path);
}

/**********************************************************************//**
 *
 * hCuԍ̎擾
 *
 ----------------------------------------------------------------------
 * @return	hCuԍ
*//***********************************************************************/
int _CLASSNAME::GetDriveNumber(void)
{
	return _FUNCTION(GetDriveNumber)(m_Path);
}

/**********************************************************************//**
 *
 * ̃Rec^Cvǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszContentType	= Rec^Cv
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsContentType(_LPCXSTR  pszContentType)
{
	return _FUNCTION(IsContentType)(m_Path, pszContentType);
}

/**********************************************************************//**
 *
 * fBNg݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL _CLASSNAME::IsDirectory(void)
{
	return _FUNCTION(IsDirectory)(m_Path);
}

/**********************************************************************//**
 *
 * fBNg󂩂ǂ
 *
 ----------------------------------------------------------------------
 * @retval	true	= 
 * @retval	false	= łȂ
*//***********************************************************************/
BOOL _CLASSNAME::IsDirectoryEmpty(void)
{
	return _FUNCTION(IsDirectoryEmpty)(m_Path);
}

/**********************************************************************//**
 *
 * ؂蕶邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	؂蕶܂܂Ă邩ǂ\^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsFileSpec(void)
{
	return _FUNCTION(IsFileSpec)(m_Path);
}

/**********************************************************************//**
 *
 * pXtH[}bgǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsLFNFileSpec(void)
{
	return _FUNCTION(IsLFNFileSpec)(m_Path);
}

/**********************************************************************//**
 *
 * lbg[ÑpXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsNetworkPath(void)
{
	return _FUNCTION(IsNetworkPath)(m_Path);
}

/**********************************************************************//**
 *
 * pXvtBbNXn܂Ă邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPrefix	= vtBbNX
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsPrefix(_LPCXSTR  pszPrefix)
{
	return _FUNCTION(IsPrefix)(pszPrefix, m_Path);
}

/**********************************************************************//**
 *
 * pX΃pXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsRelative(void)
{
	return _FUNCTION(IsRelative)(m_Path);
}

/**********************************************************************//**
 *
 * pX[gpXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsRoot(void)
{
	return _FUNCTION(IsRoot)(m_Path);
}

/**********************************************************************//**
 *
 * pX̃[gpXǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsSameRoot(_LPCXSTR  pszPath)
{
	return _FUNCTION(IsSameRoot)(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * pXVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsSystemFolder(void)
{
	return _FUNCTION(IsSystemFolder)(m_Path, 0);
}

/**********************************************************************//**
 *
 * pXUNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsUNC(void)
{
	return _FUNCTION(IsUNC)(m_Path);
}

/**********************************************************************//**
 *
 * pXT[o[\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsUNCServer(void)
{
	return _FUNCTION(IsUNCServer)(m_Path);
}

/**********************************************************************//**
 *
 * pXL\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsUNCServerShare(void)
{
	return _FUNCTION(IsUNCServerShare)(m_Path);
}

/**********************************************************************//**
 *
 * pXURL\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::IsURL(void)
{
	return _FUNCTION(IsURL)(m_Path);
}

/**********************************************************************//**
 *
 * 啶̃pXɕϊ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::MakePretty(void)
{
	return _FUNCTION(MakePretty)(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@Cɂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::MakeSystemFolder(void)
{
	return _FUNCTION(MakeSystemFolder)(m_Path);
}

/**********************************************************************//**
 *
 * pXɈv邩iChJ[hgp\j
 *
 ----------------------------------------------------------------------
 * @param [in]	pszSpec	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::MatchSpec(_LPCXSTR  pszSpec)
{
	return _FUNCTION(MatchSpec)(m_Path, pszSpec);
}

/**********************************************************************//**
 *
 * 󔒂pX '"' 
 *
*//***********************************************************************/
void _CLASSNAME::QuoteSpaces(void)
{
	_FUNCTION(QuoteSpaces)(m_Path);
}

/**********************************************************************//**
 *
 * ̃pXԂ̑΃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFrom		= Qƌ̃pX
 * @param [in]	dwAttrFrom	= Qƌ̃t@C
 * @param [in]	pszTo		= QƐ̃pX
 * @param [in]	dwAttrTo	= QƐ̃t@C
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::RelativePathTo(_LPCXSTR  pszFrom, DWORD dwAttrFrom, _LPCXSTR  pszTo, DWORD dwAttrTo)
{
	return _FUNCTION(RelativePathTo)(m_Path, pszFrom, dwAttrFrom, pszTo, dwAttrTo);
}

/**********************************************************************//**
 *
 * obNXbV폜
 *
 ----------------------------------------------------------------------
 * @retrun	폜 \ ̈ʒu
*//***********************************************************************/
_LPXSTR  _CLASSNAME::RemoveBackslash(void)
{
	return _FUNCTION(RemoveBackslash)(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Ő󔒂폜
 *
*//***********************************************************************/
void _CLASSNAME::RemoveBlanks(void)
{
	_FUNCTION(RemoveBlanks)(m_Path);
}

/**********************************************************************//**
 *
 * pXgq폜
 *
*//***********************************************************************/
void _CLASSNAME::RemoveExtension(void)
{
	_FUNCTION(RemoveExtension)(m_Path);
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::RemoveFileSpec(void)
{
	return _FUNCTION(RemoveFileSpec)(m_Path);
}

/**********************************************************************//**
 *
 * pX̊gqύX
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::RenameExtension(_LPCXSTR  pszExt)
{
	return _FUNCTION(RenameExtension)(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszBuf	= ߂tpX
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::SearchAndQualify(_LPXSTR  pszBuf, UINT cchBuf)
{
	return _FUNCTION(SearchAndQualify)(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= tpX߂pX
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::SearchAndQualify(_LPCXSTR  pszPath)
{
	return _FUNCTION(SearchAndQualify)(pszPath, m_Path, MAX_PATH);
}

/**********************************************************************//**
 *
 * k߂`̃pXRg[ɕ\
 *
 ----------------------------------------------------------------------
 * @param [in]	hDlg	= _CAOnh
 * @param [in]	id		= _CAOACeID
*//***********************************************************************/
void _CLASSNAME::SetDlgItemPath(HWND hDlg, int id)
{
	_FUNCTION(SetDlgItemPath)(hDlg, id, m_Path);
}

/**********************************************************************//**
 *
 * pX狤L폜
 *
 ----------------------------------------------------------------------
 * @retrun	LȊO̐擪|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::SkipRoot(void)
{
	return _FUNCTION(SkipRoot)(m_Path);
}

/**********************************************************************//**
 *
 * pXt@Co
 *
*//***********************************************************************/
void _CLASSNAME::StripPath(void)
{
	_FUNCTION(StripPath)(m_Path);
}

/**********************************************************************//**
 *
 * pX烋[gpXo
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::StripToRoot(void)
{
	return _FUNCTION(StripToRoot)(m_Path);
}

/**********************************************************************//**
 *
 * pXϐgppXɕύX
 *
 ----------------------------------------------------------------------
 * @param [out]	pszBuf	= o̓obt@
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::UnExpandEnvStrings(_LPXSTR  pszBuf, UINT cchBuf)
{
	return _FUNCTION(UnExpandEnvStrings)(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * pXC폜
 *
*//***********************************************************************/
void _CLASSNAME::Undecorate(void)
{
	_FUNCTION(Undecorate)(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@CłȂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL _CLASSNAME::UnmakeSystemFolder(void)
{
	return _FUNCTION(UnmakeSystemFolder)(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Õ_uNH[e[V폜
 *
*//***********************************************************************/
void _CLASSNAME::UnquoteSpaces(void)
{
	_FUNCTION(UnquoteSpaces)(m_Path);
}

/**********************************************************************//**
 *
 * t@CɎgȂ폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= ͕
 * @param [in]	max_len	= t@CƂĎgpő啶
 * @return	
*//***********************************************************************/
BOOL _CLASSNAME::FormatFileName(_LPCXSTR  pszFile, s32 max_len)
{
	if( pszFile == nullptr ) return FALSE;
	_LPCXSTR  p = pszFile;
	// 擪̃Xy[X͍폜
	while( *p == ' ' || *p == '.' )	{ ++p; }
	if( *p == '\0' ) return FALSE;
	// gpłȂ폜
	s32 len = 0;
	s32 max = max_len <= 0 ? MAX_PATH : max_len;
	do
	{
		static const _XCHAR	code[] = _XT("\\/:*?\"<>|\r\n");
		static const int	num = sizeof(code)/sizeof(code[0]);
		for( int i=0; i < num; ++i )
		{
			if( *p == code[i] ) goto block_end;	// gpsƈv
		}
		if( len >= max ) 
		{
			m_Path[len-1] = '~';
			break;
		}
		m_Path[len] = *p;
		++len;
block_end:
		;
	} while( *(++p) != '\0' );
	m_Path[len] = '\0';

	return TRUE;
}


/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	^Ul
*//***********************************************************************/
BOOL _CLASSNAME::FileExists(_LPCXSTR  pszPath)
{
	return _FUNCTION(FileExists)(pszPath);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::FindNextComponent(_LPCXSTR  pszPath)
{
	return _FUNCTION(FindNextComponent)(pszPath);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
_LPXSTR  _CLASSNAME::GetArgs(_LPCXSTR  pszPath)
{
	return _FUNCTION(GetArgs)(pszPath);
}

/**********************************************************************//**
 *
 * pX\镶̎ʂ𔻒
 *
 ----------------------------------------------------------------------
 * @param [in]	ch	= ͕
 * @return	̎(GCT_***)
*//***********************************************************************/
UINT _CLASSNAME::GetCharType(_XUCHAR ch)
{
	return _FUNCTION(GetCharType)(ch);
}

/**********************************************************************//**
 *
 * ̃t@CVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
BOOL _CLASSNAME::IsSystemFolder(DWORD dwAttrb)
{
	return _FUNCTION(IsSystemFolder)(nullptr, dwAttrb);
}

/**********************************************************************//**
 *
 * ACRpXt@CpXƃCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
int _CLASSNAME::ParseIconLocation(_LPXSTR  pszIconFile)
{
	return _FUNCTION(ParseIconLocation)(pszIconFile);
}

/**********************************************************************//**
 *
 * R}hC폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= o̓obt@
*//***********************************************************************/
void _CLASSNAME::RemoveArgs(_LPXSTR  pszPath)
{
	_FUNCTION(RemoveArgs)(pszPath);
}

}	// end of namespace wx
}	// end of namespace iris

#undef _XUCHAR
#undef _LPXSTR
#undef _LPCXSTR
#undef _CLASSNAME
#undef _FUNCTION
#undef xcscpy_s
#undef xcscat_s

#endif

#endif

