//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHExecute.cpp
 * @brief		Shell֐gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHExecute_CPP_

//======================================================================
// include
#include "WXSHExecute.h"
#include <commctrl.h>
#include <shlwapi.h>
#include <tchar.h>
#include "../wx_inchead.h"

//======================================================================
// link
#pragma comment( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
HINSTANCE CSHExecute::Run (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd)
{
#ifdef UNICODE
	return RunW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	return RunA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#endif
}
/// iris::wx::CSHExecute::Run Q
HINSTANCE CSHExecute::RunA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}
/// iris::wx::Execute Q
HINSTANCE CSHExecute::RunW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @param [out]	lpsei			= 
 * @return	nh
*//***********************************************************************/
HINSTANCE CSHExecute::Run (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFO  lpsei)
{
#ifdef UNICODE
	return RunW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd, lpsei);
#else
	return RunA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd, lpsei);
#endif
}
/// iris::wx::CSHExecute::Run Q
HINSTANCE CSHExecute::RunA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOA lpsei)
{
	SHELLEXECUTEINFOA sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( !ShellExecuteExA(&sei) ) return nullptr;
	if( lpsei != nullptr )
	{
		*lpsei = sei;
	}
	else
	{
		CloseHandle(sei.hProcess);
	}
	return sei.hInstApp;
}
/// iris::wx::CSHExecute::Run Q
HINSTANCE CSHExecute::RunW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOW lpsei)
{
	SHELLEXECUTEINFOW sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( !ShellExecuteExW(&sei) ) return nullptr;
	if( lpsei != nullptr )
	{
		*lpsei = sei;
	}
	else
	{
		CloseHandle(sei.hProcess);
	}
	return sei.hInstApp;
}

}	// end of namespace wx
}	// end of namespace iris
