//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXActiveDesktop.h
 * @brief		ActiveDesktopNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXActiveDesktop_H_
#define INCG_IRIS_WXActiveDesktop_H_

//======================================================================
// include
#include "iris_object.h"
#include "../com/WXCom.h"
#include <wininet.h>	// _WININET_Kv
#include <shlobj.h>

#if	defined(IRIS_WIN32_WCE)
typedef struct _tagWALLPAPEROPT 
{
	DWORD dwSize;
	DWORD dwStyle;
} WALLPAPEROPT, *LPWALLPAPEROPT;
typedef CONST WALLPAPEROPT	*LPCWALLPAPEROPT;

#define AD_APPLY_SAVE				0x00000001
#define AD_APPLY_HTMLGEN			0x00000002
#define AD_APPLY_REFRESH			0x00000004
#define AD_APPLY_ALL				(AD_APPLY_SAVE | AD_APPLY_HTMLGEN | AD_APPLY_REFRESH)
#define AD_APPLY_FORCE				0x00000008
#define AD_APPLY_BUFFERED_REFRESH	0x00000010
#define AD_APPLY_DYNAMICREFRESH		0x00000020

#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ActiveDesktopNX
 * @note	UNICODE
*/
class CActiveDesktop : public CCom, public INonCopyable<CActiveDesktop>
{
protected:
#if	!defined(IRIS_WIN32_WCE)
	LPACTIVEDESKTOP	m_pAD;	//!< ActiveDesktop ComIuWFNg
#endif

public:
	// RXgN^
	CActiveDesktop(void);
	// fXgN^
	~CActiveDesktop(void);

public:
	// 
	BOOL	Initialize(void);
	// 
	void	Release(void);

public:
	// ANeBx[g
	HRESULT	Activate(BOOL bComponents, BOOL bActiveDesktop);

public:
	// wrap
	HRESULT	ApplyChanges(DWORD dwFlags);

	HRESULT	GetWallpaper (LPTSTR lpszWallpaper, UINT cchWallpaper, DWORD dwReserved=0);
	HRESULT	GetWallpaperA(LPSTR  lpszWallpaper, UINT cchWallpaper, DWORD dwReserved=0);
	HRESULT	GetWallpaperW(LPWSTR lpszWallpaper, UINT cchWallpaper, DWORD dwReserved=0);

	HRESULT	SetWallpaper (LPCTSTR lpszWallpaper, DWORD dwReserved=0);
	HRESULT	SetWallpaperA(LPCSTR  lpszWallpaper, DWORD dwReserved=0);
	HRESULT	SetWallpaperW(LPCWSTR lpszWallpaper, DWORD dwReserved=0);

	HRESULT	GetWallpaperOptions(LPWALLPAPEROPT  lpwpo, DWORD dwReserved=0);
	HRESULT	SetWallpaperOptions(LPCWALLPAPEROPT lpwpo, DWORD dwReserved=0);

	HRESULT	GetPattern (LPTSTR lpszPattern, UINT cchPattern, DWORD dwReserved=0);
	HRESULT	GetPatternA(LPSTR  lpszPattern, UINT cchPattern, DWORD dwReserved=0);
	HRESULT	GetPatternW(LPWSTR lpszPattern, UINT cchPattern, DWORD dwReserved=0);

	HRESULT	SetPattern (LPCTSTR lpszPattern, DWORD dwReserved=0);
	HRESULT	SetPatternA(LPCSTR  lpszPattern, DWORD dwReserved=0);
	HRESULT	SetPatternW(LPCWSTR lpszPattern, DWORD dwReserved=0);

#if	!defined(IRIS_WIN32_WCE)
	HRESULT	GetDesktopItemOptions(LPCOMPONENTSOPT  lpco, DWORD dwReserved=0);
	HRESULT	SetDesktopItemOptions(LPCCOMPONENTSOPT lpco, DWORD dwReserved=0);

	HRESULT	AddDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	AddDesktopItemWithUI(HWND hWnd, LPCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	ModifyDesktopItem(LPCCOMPONENT lpcomp, DWORD dwFlags);
	HRESULT	RemoveDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	GetDesktopItemCount(LPINT lpiCount, DWORD dwReserved=0);

	HRESULT	GetDesktopItem(int nComponent, LPCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	GetDesktopItemByID(ULONG_PTR dwID, LPCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	GenerateDesktopItemHtml (LPCTSTR lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	GenerateDesktopItemHtmlA(LPCSTR  lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	GenerateDesktopItemHtmlW(LPCWSTR lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved=0);

	HRESULT	AddUrl (HWND hWnd, LPCTSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags);
	HRESULT	AddUrlA(HWND hWnd, LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags);
	HRESULT	AddUrlW(HWND hWnd, LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags);

	HRESULT	GetDesktopItemBySource (LPCTSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	GetDesktopItemBySourceA(LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved=0);
	HRESULT	GetDesktopItemBySourceW(LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved=0);
#endif
};

}	// end of namespace wx
}	// end of namespace iris

#endif
