//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaringTable.h
 * @brief		StringTablet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStaringTable_H_
#define INCG_IRIS_WXStaringTable_H_

//======================================================================
// include
#include "iris_object.h"
#include <map>

/*
// L`incldeOɐ錾Ă
// cpp̒`ƒu邱Ƃł
// ŏ
#define STRING_TABLE_LENGTH_MIN		64
// ő啶
// Ȃ̏ꍇ͒`Ȃ
#define STRING_TABLE_LENGTH_MAX		4096
// 擾x
// (STRING_TABLE_LENGTH_MINSTRING_TABLE_ACCURACYZẴobt@𐶐B)
#define STRING_TABLE_ACCURACY		64	
*/

namespace iris {
namespace wx
{

//======================================================================
// declare
class CStringTableA;
class CStringTableW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CStringTableW	CStringTable;
#else
typedef CStringTableA	CStringTable;
#endif

//======================================================================
// class
//! StringTableA NX
class CStringTableA : public INonCopyable<>
{
	typedef std::pair<HINSTANCE, int>	_Mykey;
	typedef std::map<_Mykey, LPSTR>		StringArray;
	typedef StringArray::iterator		iterator;
	mutable	StringArray m_StringArray;	//!< LbV
public:
	// RXgN^
	CStringTableA(void);
	// fXgN^
	virtual ~CStringTableA(void);
public:
	// 擾
	// pDefString = 擾ɎsƂɕԂ
	LPSTR	Get(HINSTANCE hInst, int nID, LPSTR pDefString=nullptr)	const;
	LPSTR	Get(int nID, LPSTR pDefString=nullptr)	const;
};

//! StringTableW NX
class CStringTableW : public INonCopyable<>
{
	typedef std::pair<HINSTANCE, int>	_Mykey;
	typedef std::map<_Mykey, LPWSTR>	StringArray;
	typedef StringArray::iterator iterator;
	mutable	StringArray m_StringArray;	//!< LbV
public:
	// RXgN^
	CStringTableW(void);
	// fXgN^
	virtual ~CStringTableW(void);
public:
	// 擾
	// pDefString = 擾ɎsƂɕԂ
	LPWSTR	Get(HINSTANCE hInst, int nID, LPWSTR pDefString=nullptr)	const;
	LPWSTR	Get(int nID, LPWSTR pDefString=nullptr)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
