//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPrivateProfile.cpp
 * @brief		PrivateProfile NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPrivateProfile_CPP_

//======================================================================
// include
#include "WXPrivateProfile.h"
#include "iris_debug.h"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "%d", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileIntA Q
BOOL WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"%d", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@Cɐl(HEX)
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "0x%x", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileHexA Q
BOOL WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"0x%x", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C琮l(HEX)擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= ftHgl
 * @param [in]	lpFileName	= t@C
 * @return	l
*//***********************************************************************/
DWORD GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName)
{
	CHAR val[128], def[128];
	wsprintfA(def, "%x", nDefault);
	DWORD size = GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	LPSTR p = nullptr;
#if 0
	DWORD ret = reinterpret_cast<DWORD>(strtol(val, &p, 16));
	if( ret == LONG_MAX )
	{
		if( errno == ERANGE )
		{
			ret = strtoul(val, &p, 16);
		}
	}
#else
	DWORD ret = strtoul(val, &p, 16);
#endif
	if( ret == 0 && p == val ) return nDefault;
	return ret;
}
/// iris::wx::GetPrivateProfileHexA Q
DWORD GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName)
{
	WCHAR val[128], def[128];
	wsprintfW(def, L"%x", nDefault);
	DWORD size = GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	LPWSTR p = nullptr;
#if 0
	DWORD ret = reinterpret_cast<DWORD>(wcstol(val, &p, 16));
	if( ret == LONG_MAX )
	{
		if( errno == ERANGE )
		{
			ret = wcstol(val, &p, 16);
		}
	}
#else
	DWORD ret = wcstoul(val, &p, 16);
#endif
	if( ret == 0 && p == val ) return nDefault;
	return ret;
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	sprintf_s(val, 128, "%f", fValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileFloatA Q
BOOL WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	swprintf_s(val, 128, L"%f", fValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @param [in]	lpFileName	= t@C
 * @return	l
*//***********************************************************************/
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName)
{
	CHAR val[128], def[128];
	sprintf_s(def, 128, "%f", fDefault);
	GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	float ret = (float)atof(val);
	return ret;
}
/// iris::wx::GetPrivateProfileFloatA Q
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName)
{
	WCHAR val[128], def[128];
	swprintf_s(def, 128, L"%f", fDefault);
	GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	float ret = (float)_wtof(val);
	return ret;
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}
/// iris::wx::WritePrivateProfileWindowPlacementA Q
BOOL WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName)
{
	return GetPrivateProfileStructA(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName)
{
	return GetPrivateProfileStructW(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPrivateProfile::CPrivateProfile(void)
{
	m_Path[0] = IRIS_TEXT('\0');
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPrivateProfile::~CPrivateProfile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
void CPrivateProfile::Open(LPCTSTR path)
{
	Close();
	_tcscpy_s(m_Path, MAX_PATH, path);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPrivateProfile::Close(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * ݂ZNV擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetSectionNames(LPTSTR lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileSectionNames(lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * ZNVɑ݂L[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetSection(LPCTSTR lpAppName, LPTSTR lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileSection(lpAppName, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C當擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpDefault	= sƂɕԂ
 * @param [out]	lpReturn	= o̓obt@(L['='؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetString(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpDefault, LPTSTR lpReturn, DWORD nSize)	const
{
	return GetPrivateProfileString(lpAppName, lpKeyName, lpDefault, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C琮l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
UINT CPrivateProfile::GetInt(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nDefault)	const
{
	return GetPrivateProfileInt(lpAppName, lpKeyName, nDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@CHEXl擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	HEXl
*//***********************************************************************/
DWORD CPrivateProfile::GetHex(LPCTSTR lpAppName, LPCTSTR lpKeyName, DWORD dwDefault)	const
{
	return GetPrivateProfileHex(lpAppName, lpKeyName, dwDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
float CPrivateProfile::GetFloat(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fDefault)	const
{
	return GetPrivateProfileFloat(lpAppName, lpKeyName, fDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C\̂擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [out]	lpStruct	= o̓obt@
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetStruct(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize)	const
{
	return GetPrivateProfileStruct(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o̓obt@(WINDOWPLACEMENT)
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl)	const
{
	return GetPrivateProfileWindowPlacement(lpAppName, lpKeyName, lpwdpl, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd)	const
{
	return GetPrivateProfileWindowPlacement(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * t@CɃL[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpString	= L[
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteSection(LPCTSTR lpAppName, LPCTSTR lpString)
{
	return WritePrivateProfileSection(lpAppName, lpString, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteInt(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nValue)
{
	return WritePrivateProfileInt(lpAppName, lpKeyName, nValue, m_Path);
}

/**********************************************************************//**
 *
 * t@CHEXl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	dwValue		= L[l
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteHex(LPCTSTR lpAppName, LPCTSTR lpKeyName, DWORD dwValue)
{
	return WritePrivateProfileHex(lpAppName, lpKeyName, dwValue, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteFloat(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fValue)
{
	return WritePrivateProfileFloat(lpAppName, lpKeyName, fValue, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɕ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpString	= 
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteString(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpString)
{
	return WritePrivateProfileString(lpAppName, lpKeyName, lpString, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɍ\̂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpStruct	= \̃|C^
 * @param [in]	nSize		= \̃TCY
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteStruct(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize)
{
	return WritePrivateProfileStruct(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= WINDOWPLACEMENT̎擾EBhEnh
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd)
{
	return WritePrivateProfileWindowPlacement(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * t@CL[폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::RemoveKey(LPCTSTR lpAppName, LPCTSTR lpKeyName)
{
	return WritePrivateProfileString(lpAppName, lpKeyName, nullptr, m_Path);
}

/**********************************************************************//**
 *
 * t@CZNV폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::RemoveSection(LPCTSTR lpAppName)
{
	return WritePrivateProfileString(lpAppName, nullptr, nullptr, m_Path);
}

/**********************************************************************//**
 *
 * t@C폜
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::Remove(void)
{
	return DeleteFile(m_Path);
}

/**********************************************************************//**
 *
 * 󂩂ǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CPrivateProfile::IsEmpty(void) const
{
	IRIS_ASSERT( IsOpen() );
	TCHAR tmp[256];
	return (GetSectionNames(tmp, 256) == 0);
}

}	// end of namespace wx
}	// end of namespace iris
