//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMappedProfile.cpp
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMappedProfile_CPP_

//======================================================================
// include
#include "WXMappedProfile.h"
#include "iris_debug.h"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMappedPrivateProfile::CMappedPrivateProfile(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMappedPrivateProfile::~CMappedPrivateProfile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CMappedPrivateProfile::Close(void)
{
	CPrivateProfile::Close();
	ClearProfileList();
}

/**********************************************************************//**
 *
 * ZNṼXg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMappedPrivateProfile::MakeAppList(void)
{
	if( !IsOpen() ) return false;
	if( !m_Profile.empty() ) return true;
	LPTSTR buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new TCHAR [size];
		if( buf == nullptr ) return false;
		DWORD ret = GetSectionNames(buf, size);
		if( ret == 0 ) 
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	LPTSTR tmp = buf;
	LPTSTR p = _tcschr(tmp, TEXT('\0'));
	while(p)
	{
		*p = TEXT('\0');
		std_tstring str = tmp;
		SectionData data;
		m_Profile.push_back(ProfilePair(str, data));
		tmp = p+1;
		p = _tcschr(tmp, TEXT('\0'));
		if( tmp == p ) break;
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * L[̃Xg
 *  ŃZNṼXg܂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
bool CMappedPrivateProfile::MakeKeyList(LPCTSTR lpAppName)
{
	if( !MakeAppList() ) return false;
	SectionData* pData = FindSectionData(lpAppName);
	if( pData == nullptr ) return false;
	return MakeKeyList(lpAppName, m_Path, *pData);
}

/**********************************************************************//**
 *
 * L[̃Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpFileName	= t@C
 * @param [out]	rData		= o
 * @return	
*//***********************************************************************/
bool CMappedPrivateProfile::MakeKeyList(LPCTSTR lpAppName, LPCTSTR lpFileName, SectionData& rData)
{
	if( lpAppName == nullptr ) return false;
	if( lpFileName == nullptr ) return false;
	LPTSTR buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new TCHAR [size];
		if( buf == nullptr ) return false;
		DWORD ret = GetPrivateProfileSection(lpAppName, buf, size, lpFileName);
		if( ret == 0 ) 
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	LPTSTR tmp = buf;
	LPTSTR p = _tcschr(tmp,TEXT('='));
	while(p)
	{
		*p = TEXT('\0');
		// L[
		std_tstring str = tmp;
		tmp = p+1;
		p = _tcschr(tmp, TEXT('\0'));

		// L[l
		KeyData val = tmp;
		rData.push_back(SectionPair(str, val));
		tmp = p+1;
		if( tmp == TEXT('\0') ) break;
		p = _tcschr(tmp, TEXT('='));
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[̃Xg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMappedPrivateProfile::MakeProfileList(void)
{
	if( !MakeAppList() ) return false;
	for( ProfileData::iterator it=m_Profile.begin(), end = m_Profile.end(); it != end; ++it)
	{
		MakeKeyList(it->first.c_str());
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[Xg̃NA
 *
*//***********************************************************************/
void CMappedPrivateProfile::ClearProfileList(void)
{
	m_Profile.clear();
}

/**********************************************************************//**
 *
 * Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
bool CMappedPrivateProfile::WriteList(bool bClear)
{
	if( !IsOpen() ) return false;
	if( bClear ) DeleteFile(m_Path);

	for( ProfileData::iterator it = m_Profile.begin(), end = m_Profile.end(); it != end; ++it )
	{
		for( SectionData::iterator sub_it = it->second.begin(), sub_end = it->second.end(); sub_it != sub_end; ++sub_it )
		{
			WritePrivateProfileString(it->first.c_str(), sub_it->first.c_str(), sub_it->second.c_str(), m_Path);
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNV̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @return	ZNV
*//***********************************************************************/
CMappedPrivateProfile::std_tstring* CMappedPrivateProfile::GetAppName(int nIndex)
{
	if( nIndex < 0 || nIndex >= (int)m_Profile.size() ) return nullptr;
	return &m_Profile[nIndex].first;
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CMappedPrivateProfile::std_tstring* CMappedPrivateProfile::GetKeyName(int nAppIndex, int nIndex)
{
	std_tstring* p = GetAppName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyName(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CMappedPrivateProfile::std_tstring* CMappedPrivateProfile::GetKeyName(LPCTSTR lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].first);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[l
*//***********************************************************************/
CMappedPrivateProfile::KeyData* CMappedPrivateProfile::GetKeyData(int nAppIndex, int nIndex)
{
	std_tstring* p = GetAppName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyData(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[l
*//***********************************************************************/
CMappedPrivateProfile::KeyData* CMappedPrivateProfile::GetKeyData(LPCTSTR lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].second);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	L[l
*//***********************************************************************/
CMappedPrivateProfile::KeyData* CMappedPrivateProfile::GetKeyData(LPCTSTR lpAppName, LPCTSTR lpKeyName)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	SectionData::iterator it = p->find(std_tstring(lpKeyName));
	if( it == p->end() ) return nullptr;
	return &it->second;
}

/**********************************************************************//**
 *
 * ZNV폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
BOOL CMappedPrivateProfile::DeleteSection(LPCTSTR lpAppName)
{
	ProfileData::iterator it = m_Profile.find(std_tstring(lpAppName));
	if( it == m_Profile.end() ) return FALSE;
	m_Profile.erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * L[폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	
*//***********************************************************************/
BOOL CMappedPrivateProfile::DeleteKey(LPCTSTR lpAppName, LPCTSTR lpKeyName)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return FALSE;
	SectionData::iterator it = p->find(std_tstring(lpKeyName));
	if( it == p->end() ) return FALSE;
	p->erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * ZNVXǧ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	ZNVf[^
*//***********************************************************************/
CMappedPrivateProfile::SectionData* CMappedPrivateProfile::FindSectionData(LPCTSTR lpAppName)
{
	ProfileData::iterator it = m_Profile.find(std_tstring(lpAppName));
	if( it == m_Profile.end() ) return nullptr;
	return &it->second;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CMappedPrivateProfileUnitTest, MappedPrivateProfileUnitTest)
{
	TCHAR path[MAX_PATH];
	std::cout << "Jinit@C͂ĂB" << std::endl;
	std::tcin >> path;

	iris::wx::CMappedPrivateProfile inifile;
	inifile.Open(path);

	inifile.MakeProfileList();

	iris::wx::CMappedPrivateProfile::ProfileData& data = inifile.GetProfileData();
	for( u32 i=0; i < data.size(); ++i )
	{
		std::tcout << TEXT("[") << data[i].first << TEXT("]") << std::endl;
		iris::wx::CMappedPrivateProfile::SectionData& sec = data[i].second;
		for( u32 i=0; i < sec.size(); ++i )
		{
			std::tcout << TEXT("\t") << sec[i].first << TEXT(" = ") << sec[i].second << std::endl;
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
