//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWow.cpp
 * @brief		Wow t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXWow_CPP_

//======================================================================
// include
#include "WXWow.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CWow64::CScopedDisable::CScopedDisable(void)
: m_pOld(nullptr)
{
	DisableFsRedirection(&m_pOld);
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CWow64::CScopedDisable::~CScopedDisable(void)
{
	RevertFsRedirection(m_pOld);
}

/**********************************************************************//**
 *
 * IsWow64
 * 
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWow64::IsWow64(HANDLE hProcess)
{
	typedef BOOL (WINAPI *PFN_IsWow64Process)(HANDLE, PBOOL);
	PFN_IsWow64Process pfn = reinterpret_cast<PFN_IsWow64Process>(GetProcAddress( GetModuleHandle(TEXT("kernel32")), "IsWow64Process" ));
	BOOL bIsWow64 = FALSE;
	if( pfn == nullptr ) return FALSE;
	if( !(*pfn)(hProcess, &bIsWow64) ) return FALSE;
	return bIsWow64;
}

/**********************************************************************//**
 *
 * Wow64on
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::EnableFsRedirection(BOOLEAN Wow64FsEnableRedirection)
{
	typedef BOOLEAN (WINAPI *PFN_Wow64EnableWow64FsRedirection)(BOOLEAN);
	PFN_Wow64EnableWow64FsRedirection pfn = reinterpret_cast<PFN_Wow64EnableWow64FsRedirection>(
		GetProcAddress( GetModuleHandle(TEXT("kernel32")), "Wow64EnableWow64FsRedirection" ));
	if( pfn == nullptr ) return FALSE;
	return (*pfn)(Wow64FsEnableRedirection);
}

/**********************************************************************//**
 *
 * Wow64off
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::DisableFsRedirection(PVOID *OldValue)
{
	typedef BOOLEAN (WINAPI *PFN_Wow64DisableWow64FsRedirection)(PVOID*);
	PFN_Wow64DisableWow64FsRedirection pfn = reinterpret_cast<PFN_Wow64DisableWow64FsRedirection>(
		GetProcAddress( GetModuleHandle(TEXT("kernel32")), "Wow64DisableWow64FsRedirection" ));
	if( pfn == nullptr ) return FALSE;
	return (*pfn)(OldValue);
}

/**********************************************************************//**
 *
 * Wow64߂
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOLEAN CWow64::RevertFsRedirection(PVOID OldValue)
{
	typedef BOOLEAN (WINAPI *PFN_Wow64RevertWow64FsRedirection)(PVOID);
	PFN_Wow64RevertWow64FsRedirection pfn = reinterpret_cast<PFN_Wow64RevertWow64FsRedirection>(
		GetProcAddress( GetModuleHandle(TEXT("kernel32")), "Wow64RevertWow64FsRedirection" ));
	if( pfn == nullptr ) return FALSE;
	return (*pfn)(OldValue);
}

}	// end of namespace wx
}	// end of namespace iris

