//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSyncObject.h
 * @brief		IuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSyncObject_H_
#define INCG_IRIS_WXSyncObject_H_

//======================================================================
// include
#include "../base/WXHandle.h"
#include "fnd/types/FndSyncObject.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
//! IuWFNgNXC^[tFCX
class ISyncObject : public CHandle, public fnd::ISyncObject
{
public:
	/// RXgN^
	ISyncObject(void) {}
	/// RXgN^
	ISyncObject(HANDLE hObject) : CHandle(hObject) {}

public:
	DWORD	Wait(DWORD dwTimeout)
	{
		return ::WaitForSingleObject(m_hObject, dwTimeout);
	}
public:
	/**
	 * @brief bN
	*/
	virtual BOOL Lock(DWORD dwTimeout)
	{
		DWORD dwRet = ::WaitForSingleObject( m_hObject, dwTimeout );
		if( dwRet == WAIT_OBJECT_0 || dwRet == WAIT_ABANDONED )
			return TRUE;
		return FALSE;
	}

	// AbN
	virtual BOOL Unlock(LONG lCount, LONG *pPrevCount = nullptr)
	{
		IRIS_UNUSED_VARIABLE(lCount);
		IRIS_UNUSED_VARIABLE(pPrevCount);
		return TRUE;
	}

public:
	/// bN擾
	virtual bool	Lock(void)
	{
		return Lock(INFINITE) != 0;
	}
	/// bN
	virtual void	Unlock(void)
	{
		Unlock(0);
	}
	/// bN擾
	virtual bool	TryLock(void)
	{
		return Lock(1) != 0;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
