//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMutex.h
 * @brief		mutexNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMutex_H_
#define INCG_IRIS_WXMutex_H_

//======================================================================
// include
#include "WXSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// mutexNX
class CMutex : public ISyncObject
{
public:
	// RXgN^
	CMutex(void);
	// RXgN^
	CMutex(BOOL bInitiallyOwn, LPCTSTR lpszName, SECURITY_ATTRIBUTES* psaAttribute);
	// fXgN^
	~CMutex(void);
	
public:
	// 
	BOOL	Init (BOOL bInitiallyOwn = FALSE, LPCTSTR lpszName = nullptr, SECURITY_ATTRIBUTES* psaAttribute = nullptr);
	BOOL	InitA(BOOL bInitiallyOwn = FALSE, LPCSTR  lpszName = nullptr, SECURITY_ATTRIBUTES* psaAttribute = nullptr);
	BOOL	InitW(BOOL bInitiallyOwn = FALSE, LPCWSTR lpszName = nullptr, SECURITY_ATTRIBUTES* psaAttribute = nullptr);

public:
	// ̖OtmutexJ
#if	!defined(IRIS_WIN32_WCE)
	BOOL	Open (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCTSTR lpName);
	BOOL	OpenA(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR  lpName);
	BOOL	OpenW(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
#endif

public:
    // AbN
    BOOL	Unlock(LONG lCount=0, LONG *pPrevCount = nullptr);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
