//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHook.cpp
 * @brief		tbNNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHook_CPP_

//======================================================================
// include
#include "WXHook.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHook::CHook(void)
: m_hHook(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHook::~CHook(void)
{
	Unhook();
}

/**********************************************************************//**
 *
 * tbNJn
 *
 ----------------------------------------------------------------------
 * @param [in]	idHook		= 
 * @param [in]	lpfn		= 
 * @param [in]	hmod		= 
 * @param [in]	dwThreadId	= 
 * @return	
*//***********************************************************************/
BOOL CHook::Hook(int idHook, HOOKPROC lpfn, HINSTANCE hmod, DWORD dwThreadId)
{
	Unhook();
	m_hHook = SetWindowsHookEx(idHook, lpfn, hmod, dwThreadId);
	if( m_hHook == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHook::Unhook(void)
{
	if( m_hHook == nullptr ) return FALSE;
	return UnhookWindowsHookEx(m_hHook);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
LRESULT CHook::CallNextHookEx(int nCode, WPARAM wParam, LPARAM lParam)
{
	if( m_hHook == nullptr ) return S_OK;
	return ::CallNextHookEx(m_hHook, nCode, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
