//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXTCP.cpp
 * @brief		TCPsocketNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXTCP_CPP_

//======================================================================
// include
#include "WXTCP.h"
#include <winsock2.h>
#include <string>

//======================================================================
// link
#pragma comment ( lib, "wsock32.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
//======================================================================
// CTCPSocket

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CTCPSocket::CTCPSocket(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CTCPSocket::~CTCPSocket(void)
{
}

/**********************************************************************//**
 *
 * ڑL[̍쐬
 *
 * @note	(T[o)
 *
 ----------------------------------------------------------------------
 * @param [in]	backlog	= 
 * @return	
*//***********************************************************************/
int CTCPSocket::Listen(int backlog)
{
	return listen(m_Socket, backlog);
}

/**********************************************************************//**
 *
 * ڑ 
 *
 * @note	(T[o)
 *
 ----------------------------------------------------------------------
 * @param [in]	pAddr		= 
 * @param [in]	pAddrLen	= pAddr ̃TCY 
 * @return	
*//***********************************************************************/
SOCKET CTCPSocket::Accept(sockaddr* pAddr, int* pAddrLen)
{
	return accept(m_Socket, pAddr, pAddrLen);
}

/**********************************************************************//**
 *
 * ڑ
 *
 * @note	(NCAg)
 *
 ----------------------------------------------------------------------
 * @param [in]	pAddr	= 
 * @param [in]	namelen	= pAddr ̃TCY 
 * @return	
*//***********************************************************************/
int CTCPSocket::Connect(sockaddr* pAddr, int namelen)
{
	return connect(m_Socket, pAddr, namelen);
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= Mobt@
 * @param [in]	len			= obt@TCY
 * @param [in]	flags		= 
 * @return	
*//***********************************************************************/
int CTCPSocket::Send(LPCSTR lpBuffer, int len, int flags)
{
	return send(m_Socket, lpBuffer, len, flags);
}

/**********************************************************************//**
 *
 * M(sver)
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= Mobt@
 * @param [in]	len			= obt@TCY
 * @param [in]	flags		= 
 * @return	
*//***********************************************************************/
int CTCPSocket::SendNL(LPCSTR lpBuffer, int len, int flags)
{
	IRIS_UNUSED_VARIABLE(len);
	std::string str;
	if( lpBuffer == nullptr )
	{
		str = __CRLF;
	}
	else
	{
		str = lpBuffer;
		str += __CRLF;
	}
	return send(m_Socket, str.c_str(), (int)str.length(), flags);
}

/**********************************************************************//**
 *
 * M
 *
 ----------------------------------------------------------------------
 * @param [in]	lpBuffer	= Mobt@
 * @param [in]	len			= obt@TCY
 * @param [in]	flags		= 
 * @return	
*//***********************************************************************/
int CTCPSocket::Recv(LPSTR lpBuffer, int len, int flags)
{
	int length = recv(m_Socket, lpBuffer, len-1, flags);
	if( length > 0 && lpBuffer != nullptr )
	{
		lpBuffer[length] = '\0';
	}
	return length;
}

}	// end of namespace wx
}	// end of namespace iris
