//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMWaveFile.h
 * @brief		Wavet@Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMWaveFile_H_
#define INCG_IRIS_WXMMWaveFile_H_

//======================================================================
// include
#include "audio/format/AXAudioFile.h"
#include <mmsystem.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! Wavet@CNX
class CMMWaveFile : public ax::IAXFile
{
protected:
	WAVEFORMATEX	m_WaveFmt;	//!< tH[}bg
	HMMIO			m_hMmio;	//!< t@Cnh
	s32				m_Offset;	//!< f[^ւ̃ItZbg
	u32				m_Size;		//!< TCY

public:
	// RXgN^
	CMMWaveFile(void);
	// fXgN^
	virtual ~CMMWaveFile(void);

public:
	// J
	virtual	bool			OpenA(LPSTR   filename);
	virtual	bool			OpenW(LPWSTR  filename);
	// 
	virtual	void			Close(void);

public:
	// PCMf[^̓ǂݎ
	virtual s32				ReadPCM(void* lpBuffer, u32 length);
	// WAVEFORMATEX̎擾
	virtual bool			GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;
	// WAVEFORMATEX̎擾
	virtual LPWAVEFORMATEX	GetWaveFormatEx(void)			{ return &m_WaveFmt; }
	// f[^TCY̎擾
	virtual	u32				GetSize(void)		const		{ return m_Size; }
	// f[^TCY̎擾
	virtual	u32				GetSizePCM(void)	const		{ return m_Size; }

public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);


public:
	// t@Cɏ
	static	MMRESULT		WriteFile (LPTSTR filename, void* lpBuffer, u32 uSize, LPWAVEFORMATEX pwfex);
	static	MMRESULT		WriteFileA(LPSTR  filename, void* lpBuffer, u32 uSize, LPWAVEFORMATEX pwfex);
	static	MMRESULT		WriteFileW(LPWSTR filename, void* lpBuffer, u32 uSize, LPWAVEFORMATEX pwfex);

protected:
	// ʃI[v
	virtual	bool			_Open(void);
	// ʏݏ
	static	MMRESULT		_Write(HMMIO hMmio, void* lpBuffer, u32 uSize, LPWAVEFORMATEX pwfex);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
