//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMSysError.h
 * @brief		mmsystemG[R[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMSysError_H_
#define INCG_IRIS_WXMMSysError_H_

//======================================================================
// include
#include <mmsystem.h>
#include "../debug/WXDebug.h"

//======================================================================
// function

//======================================================================
// define

#ifdef _IRIS_DEBUG

#define WX_MM_ERROR(hResult)			do { if( hResult != MMSYSERR_NOERROR ) { TCHAR err_str[256]; waveOutGetErrorText(hResult,err_str,256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :%d:<%s>.\n")  , __LINE__, hResult, err_str); } } while(0)
#define WX_MM_ERROR2(hResult, comm)		do { if( hResult != MMSYSERR_NOERROR ) { TCHAR err_str[256]; waveOutGetErrorText(hResult,err_str,256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:%d:<%s>.\n"), __LINE__, comm, hResult, err_str); } } while(0)
#define WX_MM_CHECK_RESULT(exp)			do { HRESULT hResult = (exp); if( hResult != MMSYSERR_NOERROR ) {				\
											TCHAR err_str[256]; waveOutGetErrorText(hResult,err_str,256);	\
											dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, #exp, err_str); \
										} } while(0)
#define WX_MM_DO_CHECK_RESULT(exp,todo)	do { HRESULT hResult = (exp); if( hResult != MMSYSERR_NOERROR ) {				\
											TCHAR err_str[256]; waveOutGetErrorText(hResult,err_str,256);	\
											dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, #exp, err_str); \
											todo;														\
										} } while(0)

#else

#define WX_MM_ERROR(hResult)			(void)(0)
#define WX_MM_ERROR2(hResult,comm)		(void)(0)
#define WX_MM_CHECK_RESULT(exp)			exp
#define WX_MM_DO_CHECK_RESULT(exp,ret)	do { if( FAILED(exp) ) { ret; } } while(0)

#endif

#endif
