//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGlobalMemory.cpp
 * @brief		O[onhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGlobalMemory_CPP_

//======================================================================
// include
#include "WXGlobalMemory.h"

namespace iris {
namespace wx 
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGlobalMemory::CGlobalMemory(void)
: m_hMem(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGlobalMemory::~CGlobalMemory(void)
{
	Free();
}

/**********************************************************************//**
 *
 * Attach
 *
 * @note	Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @param [in]	hMem	= 蓖Ănh
 * @return	ȑÕnh
*//***********************************************************************/
HGLOBAL CGlobalMemory::Attach(HGLOBAL hMem)
{
	HGLOBAL hPreMem = m_hMem;
	m_hMem = hMem;
	return hPreMem;
}

/**********************************************************************//**
 *
 * Attach
 *
 * @note	Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑÕnh
*//***********************************************************************/
HGLOBAL CGlobalMemory::Detach(void)
{
	HGLOBAL hPreMem = m_hMem;
	m_hMem = nullptr;
	return hPreMem;
}

/**********************************************************************//**
 *
 * Alloc
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= GMEM_***
 * @param [in]	dwBytes	= 蓖ĂoCg
 * @return	
*//***********************************************************************/
bool CGlobalMemory::Alloc(UINT uFlags, SIZE_T dwBytes)
{
	m_hMem = GlobalAlloc(uFlags, dwBytes);
	return (m_hMem != 0);
}

/**********************************************************************//**
 *
 * ReAlloc
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags	= GMEM_***
 * @param [in]	dwBytes	= 蓖ĂoCg
 * @return	
*//***********************************************************************/
bool CGlobalMemory::ReAlloc(UINT uFlags, SIZE_T dwBytes)
{
	if( m_hMem == nullptr ) return false;
	m_hMem = GlobalReAlloc(m_hMem, dwBytes, uFlags);
	return (m_hMem != 0);
}

/**********************************************************************//**
 *
 * 폜ibNJEg0̂ƂA폜j
 *
*//***********************************************************************/
void CGlobalMemory::Discard(void)
{
	if( m_hMem != nullptr )
		m_hMem = GlobalDiscard(m_hMem);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CGlobalMemory::Free(void)
{
	if( m_hMem != nullptr )
		GlobalFree(m_hMem);
	m_hMem = nullptr;
}

/**********************************************************************//**
 *
 * Lock
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
LPVOID CGlobalMemory::Lock(void)
{
	if( m_hMem == nullptr ) return nullptr;
	return GlobalLock(m_hMem);
}

/**********************************************************************//**
 *
 * Unlock
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CGlobalMemory::Unlock(void)
{
	return GlobalUnlock(m_hMem);
}

/**********************************************************************//**
 *
 * TCY擾
 *
 ----------------------------------------------------------------------
 * @return	TCY
*//***********************************************************************/
SIZE_T CGlobalMemory::GetSize(void)	const
{
	if( m_hMem == nullptr ) return 0;
	return GlobalSize(m_hMem);
}

/**********************************************************************//**
 *
 * tO擾
 *
 ----------------------------------------------------------------------
 * @return	tO
*//***********************************************************************/
UINT CGlobalMemory::GetFlags(void)	const
{
	if( m_hMem == nullptr ) return 0;
	return GlobalFlags(m_hMem);
}

}	// end of namespace wx
}	// end of namespace iris
