//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHFile.h
 * @brief		t@CnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHFile_H_
#define INCG_IRIS_WXHFile_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! t@CnhNX
class CHFile : public CHandle
{
public:
	// RXgN^
	CHFile(void);
	CHFile(HANDLE hFile);
	// fXgN^
	virtual ~CHFile(void);
public:
	// J
	BOOL	Open (LPCTSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
						, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
	BOOL	OpenA(LPCSTR  lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
						, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
	BOOL	OpenW(LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes
						, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
	// J
	BOOL	Open (LPCTSTR lpFileName, LPCTSTR mode);
	BOOL	OpenA(LPCSTR  lpFileName, LPCSTR  mode);
	BOOL	OpenW(LPCWSTR lpFileName, LPCWSTR mode);

	// t@CTCY擾
	DWORD	GetSize(LPDWORD lpdwSizeHigh=nullptr)	const;

	// ǂݍ
	BOOL	Read  (void* lpBuffer, DWORD dwSize, LPDWORD lpdwRead, LPOVERLAPPED lpOverlapped=nullptr);
#if	!defined(IRIS_WIN32_WCE)
	BOOL	ReadEx(void* lpBuffer, DWORD dwSize, LPOVERLAPPED_COMPLETION_ROUTINE lpFunction, LPOVERLAPPED lpOverlapped=nullptr);
#endif
	// 
	BOOL	Write  (void* lpBuffer, DWORD dwSize, LPDWORD lpdwWritten, LPOVERLAPPED lpOverlapped=nullptr);
#if	!defined(IRIS_WIN32_WCE)
	BOOL	WriteEx(void* lpBuffer, DWORD dwSize, LPOVERLAPPED_COMPLETION_ROUTINE lpFunction, LPOVERLAPPED lpOverlapped=nullptr);
#endif
	// FLUSH
	BOOL	Flush(void);

public:
	// t@C̈ʒu擾
	DWORD	Tell(void)	const;
	// t@C̈ʒuړ
	DWORD	Seek(LONG lOffset, PLONG lpOffsetHigh, DWORD MoveMethod);
	// t@C̏I[Ɉړ
	BOOL	SetEndOfFile(void);
public:

	// Lock
	BOOL	Lock  (DWORD dwOffsetLow, DWORD dwOffsetHigh, DWORD dwSizeLow, DWORD dwSizeHigh);
	BOOL	LockEx(DWORD dwFlags, DWORD dwSizeLow, DWORD dwSizeHigh, LPOVERLAPPED lpOverlapped);
	// Unlock
	BOOL	Unlock  (DWORD dwOffsetLow, DWORD dwOffsetHigh, DWORD dwSizeLow, DWORD dwSizeHigh);
	BOOL	UnlockEx(DWORD dwSizeLow, DWORD dwSizeHigh, LPOVERLAPPED lpOverlapped);

public:
	// OVERLAPPED ̌ʎ擾
#if	!defined(IRIS_WIN32_WCE)
	BOOL	GetOverlappedResult(LPOVERLAPPED lpOverlapped, LPDWORD lpNumberOfBytes, BOOL bWait);
#endif

public:
	// t@C̎Ԋ֌W̎擾
	BOOL	GetFileTime(LPFILETIME lpCreation, LPFILETIME lpLastAccess, LPFILETIME lpLastWrite);
	// t@C̎Ԋ֌W̐ݒ
	BOOL	SetFileTime(const FILETIME* lpCreation, const FILETIME* lpLastAccess, const FILETIME* lpLastWrite);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
