//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFile.cpp
 * @brief		Window FILE* NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFile_CPP_

//======================================================================
// include
#include "WXFile.h"
#if	!defined(IRIS_WIN32_WCE)
#include <io.h>
#include <fcntl.h>
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFile::CFile(void)
: m_hCRT(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFile::~CFile(void)
{
	if( m_hCRT != 0 )
	{
		Detach();	// nhI[vt@C|C^͎ close Ȃ
	}
}

/**********************************************************************//**
 *
 * nhI[v
 *
 ----------------------------------------------------------------------
 * @param [in]	hObject	= nh
 * @param [in]	mode	= [h
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
bool CFile::OpenFromHandle (intptr_t hObject, LPCTSTR mode)
{
#ifdef UNICODE
	return OpenFromHandleW(hObject, mode);
#else
	return OpenFromHandleA(hObject, mode);
#endif
}
/// CFile::OpenFromHandle Q
bool CFile::OpenFromHandleA(intptr_t hObject, LPCSTR  mode)
{
	m_hCRT = _open_osfhandle(hObject, _O_RDWR);
	FILE* fp = _fdopen(m_hCRT, mode);
	return Attach(fp);
}
/// CFile::OpenFromHandle Q
bool CFile::OpenFromHandleW(intptr_t hObject, LPCWSTR mode)
{
	m_hCRT = _open_osfhandle(hObject, _O_RDWR);
	FILE* fp = _wfdopen(m_hCRT, mode);
	return Attach(fp);
}
#endif

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
int CFile::Close(void)
{
	m_hCRT = 0;
	return fnd::CFile::Close();
}

}	// end of namespace wx
}	// end of namespace iris

