//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComPort.h
 * @brief		Communication Port t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXComPort_H_
#define INCG_IRIS_WXComPort_H_

//======================================================================
// include
#include "WXHFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// COM port NX
class CComPort : public CHFile
{
public:
	// RXgN^
	CComPort(void);
	// fXgN^
	~CComPort(void);

public:
	// J
	BOOL	Open(int nPortNo, DWORD dwFlagsAndAttributes=0, DWORD dwDesiredAccess=GENERIC_READ|GENERIC_WRITE, DWORD dwShareMode=0);

public:
	// M
	DWORD	Send(LPVOID lpBuffer, DWORD dwSize);
	BOOL	Send(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwWritten, LPOVERLAPPED lpOverlapped);
	// M
	DWORD	Recv(LPVOID lpBuffer, DWORD dwSize);
	BOOL	Recv(LPVOID lpBuffer, DWORD dwSize, LPDWORD lpdwRead, LPOVERLAPPED lpOverlapped);
	// f
	BOOL	Break(void);
	// ؒfԂ̉
	BOOL	ClearBreak(void);
	// ʐM̉
	BOOL	Purge(DWORD dwFlags);

public:
	// ʐMG[̎擾
	BOOL	ClearError(LPDWORD lpError, LPCOMSTAT lpStat);
	// ʐMԂ̎擾
	BOOL	GetStat(LPCOMSTAT lpStat)	const;
	// Ԃ̎擾
	BOOL	GetProperties(LPCOMMPROP lpProp)	const;
public:
	// \̐ݒ
	BOOL	SetConfig(LPCOMMCONFIG lpConfig);
	// |[gݒ
	BOOL	SetState(LPDCB lpDCB);
	// |[gݒ̎擾
	BOOL	GetState(LPDCB lpDCB)	const;
	// }XNl̐ݒ
	BOOL	SetMask(DWORD dwMask);
	// }XNl̎擾
	DWORD	GetMask(void)	const;
	// ^CAEgԂ̐ݒ
	BOOL	SetTimeouts(LPCOMMTIMEOUTS lpTimeouts);
	// ^CAEgԂ̎擾
	BOOL	GetTimeouts(LPCOMMTIMEOUTS lpTimeouts)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
