//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboard.cpp
 * @brief		Nbv{[hNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXClipboard_CPP_

//======================================================================
// include
#include "WXClipboard.h"
#include "../memory/WXGlobalMemory.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CClipboard::CClipboard(void)
: m_hOwner(nullptr)
, m_isOpen(false)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWndNewOwner	= I[i[EBhE
*//***********************************************************************/
CClipboard::CClipboard(HWND hWndNewOwner)
: m_hOwner(nullptr)
, m_isOpen(false)
{
	Open(hWndNewOwner);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CClipboard::~CClipboard(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	hWndNewOwner	= VKI[i[EBhEnh(nullptr:݂̃^XNJ)
 * @return	
*//***********************************************************************/
BOOL CClipboard::Open(HWND hWndNewOwner)
{
	BOOL ret = OpenClipboard(hWndNewOwner);
	if( ret != 0 )
	{
		m_isOpen = true;
		m_hOwner = hWndNewOwner;
	}
	return ret;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboard::Close(void)
{
	if( !m_isOpen ) return FALSE;
	return CloseClipboard();
}

/**********************************************************************//**
 *
 * JĂ邩
 *
 -----------------------------------------------------------------------
 * @return	JĂTRUE
*//***********************************************************************/
bool CClipboard::IsOpen(void)	const
{
	return m_isOpen;
}

/**********************************************************************//**
 *
 * f[^ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= tH[}bg(CF_*** or user register)
 * @param [in]	hMem	= f[^̃nh
 * @return	
*//***********************************************************************/
HANDLE CClipboard::SetData(UINT uFormat, HANDLE hMem)
{
	if( m_hOwner == nullptr ) return nullptr;
	return SetClipboardData(uFormat, hMem);
}

/**********************************************************************//**
 *
 * f[^擾
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= tH[}bg(CF_***)
 * @return	f[^̃nh
*//***********************************************************************/
HANDLE CClipboard::GetData(UINT uFormat)	const
{
	return GetClipboardData(uFormat);
}

/**********************************************************************//**
 *
 * f[^ɂ
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboard::Empty(void)
{
	return EmptyClipboard();
}

/**********************************************************************//**
 *
 * f[^̗L
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= tH[}bg(CF_***)
 * @return	L
*//***********************************************************************/
BOOL CClipboard::IsFormatAvailable(UINT uFormat)	const
{
	return IsClipboardFormatAvailable(uFormat);
}

/**********************************************************************//**
 *
 * I[i[EBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	I[i[EBhEnh
*//***********************************************************************/
HWND CClipboard::GetOwner(void)	const
{
	return GetClipboardOwner();
}

/**********************************************************************//**
 *
 * OpenĂEBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CClipboard::GetOpenWindow(void)	const
{
	return m_hOwner;
	//return GetOpenClipboardWindow();
}

/**********************************************************************//**
 *
 * Nbv{[h̃V[PXԍ擾
 *
 -----------------------------------------------------------------------
 * @return	Nbv{[h̃V[PXԍ
 * @retval	0 = EBhEXe[Vւ WINSTA_ACCESSCLIPBOARD ANZXȂ
*//***********************************************************************/
DWORD CClipboard::GetSequenceNumber(void)	const
{
#if	!defined(IRIS_WIN32_WCE)
	return GetClipboardSequenceNumber();
#else
	return 0;
#endif
}

/**********************************************************************//**
 *
 * tH[}bg̎擾
 *
 -----------------------------------------------------------------------
 * @return	tH[}bg
*//***********************************************************************/
int CClipboard::CountFormats(void)	const
{
	return CountClipboardFormats();
}

/**********************************************************************//**
 *
 * tH[}bg̗
 *
 -----------------------------------------------------------------------
 * @return	JgtH[}bgiJn 0 j
 * @return	̃tH[}bg
*//***********************************************************************/
UINT CClipboard::EnumFormats(UINT uFormat)
{
	if( m_hOwner == nullptr ) return FALSE;
	return EnumClipboardFormats(uFormat);
}

/**********************************************************************//**
 *
 * Xg̒ŏɗpłNbv{[htH[}bg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	paPriorityList	= o
 * @param [in]	nFormats		= paPriorityList̔z
 * @return	tH[}bg
 * @reval	0	= Nbv{[h
 * @reval	1	= XĝǂƂvȂ
*//***********************************************************************/
int CClipboard::GetPriorityFormat(UINT* paPriorityList, int nFormats)	const
{
	return GetPriorityClipboardFormat(paPriorityList, nFormats);
}

/**********************************************************************//**
 *
 * Nbv{[h̐VtH[}bg Windows VXeɓo^
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFormat	= tH[}bg
 * @return	tH[}bgʎq
*//***********************************************************************/
UINT CClipboard::RegisterFormat (LPCTSTR lpszFormat)
{
	return RegisterClipboardFormat(lpszFormat);
}
/// CClipboard::RegisterFormat Q
UINT CClipboard::RegisterFormatA(LPCSTR  lpszFormat)
{
	return RegisterClipboardFormatA(lpszFormat);
}
/// CClipboard::RegisterFormat Q
UINT CClipboard::RegisterFormatW(LPCWSTR lpszFormat)
{
	return RegisterClipboardFormatW(lpszFormat);
}

/**********************************************************************//**
 *
 * o^ς݃tH[}bg擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFormat		= 擾tH[}bg
 * @param [out]	lpszFormatName	= óBtH[}bg
 * @param [in]	cchMaxCount		= tH[}bg̃TCY
 * @return	o͂ɃRs[ꂽTCY
*//***********************************************************************/
int CClipboard::GetFormatName (UINT uFormat, LPTSTR lpszFormatName, int cchMaxCount)	const
{
	return GetClipboardFormatName (uFormat, lpszFormatName, cchMaxCount);
}
/// CClipboard::GetFormatName Q
int CClipboard::GetFormatNameA(UINT uFormat, LPSTR  lpszFormatName, int cchMaxCount)	const
{
	return GetClipboardFormatNameA(uFormat, lpszFormatName, cchMaxCount);
}
/// CClipboard::GetFormatName Q
int CClipboard::GetFormatNameW(UINT uFormat, LPWSTR lpszFormatName, int cchMaxCount)	const
{
	return GetClipboardFormatNameW(uFormat, lpszFormatName, cchMaxCount);
}

/**********************************************************************//**
 *
 * Nbv{[hr[Ã`FCɂŏ̃EBhE擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CClipboard::GetViewer(void)	const
{
#if	!defined(IRIS_WIN32_WCE)
	return GetClipboardViewer();
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * VACY
 *
 -----------------------------------------------------------------------
 * @param [out]	buf		= o̓obt@
 * @param [in]	size	= o̓obt@TCY
 * @param [in]	uFormat	= tH[}bg(CF_***)
 * @return	܂ꂽTCY
*//***********************************************************************/
u32 CClipboard::Serialize(void* buf, u32 size, UINT uFormat)
{
	bool close=false;
	CGlobalMemory gmem;
	if( !IsOpen() ) 
	{
		if( !Open(nullptr) ) return 0;
		close = true;
	}

	gmem = GetData(uFormat);
	SIZE_T memsize = gmem.GetSize();
	if( memsize > size ) memsize = size;
	void* src = gmem.Lock();
	memcpy(buf, src, memsize);
	gmem.Unlock();
	gmem.Detach();

	if( close ) Close();
	return 0;
}

/**********************************************************************//**
 *
 * fVACY
 *
 -----------------------------------------------------------------------
 * @param [in]	buf		= ̓obt@
 * @param [in]	size	= ̓obt@TCY
 * @param [in]	uFormat	= tH[}bg(CF_***)
 * @return	񂽃TCY
*//***********************************************************************/
u32 CClipboard::Deserialize(void* buf, u32 size, UINT uFormat)
{
	bool close=false;
	CGlobalMemory gmem;
	if( !IsOpen() ) 
	{
		if( !Open(nullptr) ) return 0;
		close = true;
	}

	gmem.Alloc(GHND, size);
	void* dst = gmem.Lock();
	memcpy(dst, buf, size);
	gmem.Unlock();
	SetData(uFormat, gmem.Detach());

	if( close ) Close();
	return 0;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include <tchar.h>
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXClipboardUnitTest, WXClipboardUnitTest)
{
	CClipboard clip;
	if( !clip.Open(GetDesktopWindow()) ) return;

	for( int i=0; i < 2; ++i )
	{
		CGMem gmem;
		if( clip.IsFormatAvailable(CF_TEXT) )
		{
			gmem = clip.GetData(CF_TEXT);
			LPVOID p = gmem.Lock();
			if( p != nullptr )
			{
				char* c = (char*)p;
				puts(c);
				gmem.Unlock();
			}
			gmem.Detach();
		}
		if( i == 1 ) break;

		clip.Empty();
		char buf[256];
		std::cout << "͂ĂB" << std::endl;
		std::cin >> buf;
		size_t len = strlen(buf) + 1;
		gmem.Alloc(GHND, len);
		char* p = (char*)gmem.Lock();
		if( p != nullptr )
		{
			strcpy_s(p, len, buf);
			clip.SetData(CF_TEXT, gmem );
			gmem.Unlock();
			gmem.Detach();
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

