//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXAccelerator.cpp
 * @brief		ANZ[^NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXAccelerator_CPP_

//======================================================================
// include
#include "WXAccelerator.h"
#include "../control/WXMenu.h"
#include <tchar.h>
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAccelerator::CAccelerator(void)
: m_hAccel(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	hAccel	= ANZ[^nh
*//***********************************************************************/
CAccelerator::CAccelerator(HACCEL hAccel)
: m_hAccel(nullptr)
{
	Attach(hAccel);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAccelerator::~CAccelerator(void)
{
	Destroy();
}

/**********************************************************************//**
 *
 * ֘At
 *
 -----------------------------------------------------------------------
 * @param [in] hAccel	= ֘Atnh
 * @return 
*//***********************************************************************/
BOOL CAccelerator::Attach(HACCEL hAccel)
{
	if( hAccel == nullptr || m_hAccel != nullptr ) return FALSE;
	m_hAccel = hAccel;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̎s
 *
 -----------------------------------------------------------------------
 * @param [in] hAccel	= ֘Atnh
 * @return 
*//***********************************************************************/
BOOL CAccelerator::TryAttach(HACCEL hAccel)
{
	if( !Attach(hAccel) )
	{
		DestroyAcceleratorTable(hAccel);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̉
 *
 -----------------------------------------------------------------------
 * @return ȑÕnh
*//***********************************************************************/
HACCEL CAccelerator::Detach(void)
{
	HACCEL hPre = m_hAccel;
	m_hAccel = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * ANZ[^e[u̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAccel = e[u
 * @param [in]	nAccel	= e[u̔zvf
 * @return 
*//***********************************************************************/
BOOL CAccelerator::Create(LPACCEL lpAccel, s32 nAccel)
{
#ifdef UNICODE
	return CreateW(lpAccel, nAccel);
#else
	return CreateA(lpAccel, nAccel);
#endif
}
/// CAccelerator::Create Q
BOOL CAccelerator::CreateA(LPACCEL lpAccel, s32 nAccel)
{
	HACCEL hAccel = CreateAcceleratorTableA(lpAccel, nAccel);
	return TryAttach(hAccel);
}
/// CAccelerator::Create Q
BOOL CAccelerator::CreateW(LPACCEL lpAccel, s32 nAccel)
{
	HACCEL hAccel = CreateAcceleratorTableW(lpAccel, nAccel);
	return TryAttach(hAccel);
}

/**********************************************************************//**
 *
 * ANZ[^e[u̔j
 *
 -----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
BOOL CAccelerator::Destroy(void)
{
	return DestroyAcceleratorTable(Detach());
}

/**********************************************************************//**
 *
 * ANZ[^e[ũ\[Xǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	lpTableName	= e[u
 * @return 
*//***********************************************************************/
BOOL CAccelerator::Load (HINSTANCE hInstance, LPCTSTR lpTableName)
{
#ifdef UNICODE
	return LoadW(hInstance, lpTableName);
#else
	return LoadA(hInstance, lpTableName);
#endif
}
/// CAccelerator::Load Q
BOOL CAccelerator::LoadA(HINSTANCE hInstance, LPCSTR  lpTableName)
{
	HACCEL hAccel = LoadAcceleratorsA(hInstance, lpTableName);
	return TryAttach(hAccel);
}
/// CAccelerator::Load Q
BOOL CAccelerator::LoadW(HINSTANCE hInstance, LPCWSTR lpTableName)
{
	HACCEL hAccel = LoadAcceleratorsW(hInstance, lpTableName);
	return TryAttach(hAccel);
}

/**********************************************************************//**
 *
 * ANZ[^e[ũRs[
 *
 -----------------------------------------------------------------------
 * @param [out]	lpAccelDst	= o̓e[u
 * @param [in]	nCount		= o͐
 * @return o͐ (lpAccelDst  nullptr ^ƕKvȐ擾)
*//***********************************************************************/
int CAccelerator::CopyTable (LPACCEL lpAccelDst, int nCount)
{
#if	!defined(IRIS_WIN32_WCE)
	return CopyAcceleratorTable(m_hAccel, lpAccelDst, nCount);
#else
	return -1;
#endif
}
/// CAccelerator::CopyTable Q
int CAccelerator::CopyTableA(LPACCEL lpAccelDst, int nCount)
{
#if	!defined(IRIS_WIN32_WCE)
	return CopyAcceleratorTableA(m_hAccel, lpAccelDst, nCount);
#else
	return -1;
#endif
}
/// CAccelerator::CopyTable Q
int CAccelerator::CopyTableW(LPACCEL lpAccelDst, int nCount)
{
#if	!defined(IRIS_WIN32_WCE)
	return CopyAcceleratorTableW(m_hAccel, lpAccelDst, nCount);
#else
	return -1;
#endif
}

/**********************************************************************//**
 *
 * ANZ[^e[u̐擾
 *
 -----------------------------------------------------------------------
 * @return e[u
*//***********************************************************************/
int CAccelerator::GetTableNum(void)
{
	return CopyTable(nullptr, 0);
}

/**********************************************************************//**
 *
 * j[ɃANZ[^̏ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	hMenu	= j[nh
 * @return 
*//***********************************************************************/
BOOL CAccelerator::ApplyMenu(HMENU hMenu)
{
	IRIS_VERIFYRETURN( IsMenu(hMenu), FALSE );
	int numTable = GetTableNum();
	if( numTable == 0 ) return TRUE;

	LPACCEL pAccel = new ACCEL [numTable];
	numTable = CopyTable(pAccel, numTable);
	BOOL ret = ApplyMenu(hMenu, pAccel, numTable);
	delete pAccel;
	return ret;
}

/**********************************************************************//**
 *
 * j[ɃANZ[^̏ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	hMenu	= j[nh
 * @param [in]	lpAccel	= ANZ[^e[u
 * @param [in]	nCount	= ANZ[^e[u̐
 * @return 
*//***********************************************************************/
BOOL CAccelerator::ApplyMenu(HMENU hMenu, LPACCEL lpAccel, int nCount)
{
	IRIS_ASSERT( lpAccel != nullptr );

	TCHAR str[256]=TEXT("");

	MENUITEMINFO mi;
	memset(&mi,0,sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= MIIM_ID | MIIM_TYPE;
	mi.fType	= MFT_STRING;

	for( int i=0; i < nCount; ++i )
	{
		mi.dwTypeData = nullptr;
		HMENU hParentMenu = FindMenuItemInfo(hMenu, lpAccel[i].cmd, MF_BYCOMMAND, &mi);
		if( hParentMenu == nullptr ) continue;

		if( mi.cch >= 256 )
		{
			// ΉȂ
			IRIS_WARNING("j[̕񂪒܂");
			continue;
		}

		mi.dwTypeData = str;
		IRIS_VERIFY( FindMenuItemInfo(hMenu, lpAccel[i].cmd, MF_BYCOMMAND, &mi) != nullptr );

		LPTSTR p = _tcsrchr(str, TEXT('\t'));
		if(p != nullptr) *p = TEXT('\0');

		WORD key = lpAccel[i].key;
		BYTE fv = lpAccel[i].fVirt;
		_tcscat_s(str, IRIS_NumOfElements(str), TEXT("\t"));
		TCHAR temp[8];
		if(fv & FCONTROL)
		{
			_tcscat_s(str, IRIS_NumOfElements(str), TEXT("Ctrl+"));
		}
		if(fv & FSHIFT)
		{
			_tcscat_s(str, IRIS_NumOfElements(str), TEXT("Shift+"));
		}
		if(fv & FALT)
		{
			_tcscat_s(str, IRIS_NumOfElements(str), TEXT("Alt+"));
		}
		if( key >= TEXT('A') && key <= TEXT('Z'))
		{
			temp[0] = (TCHAR)key;
			temp[1] = TEXT('\0');
		}
		else if( key >= VK_F1 && key < VK_F24)
		{
			wsprintf(temp, TEXT("F%d"), key-VK_F1+1);
		}
		_tcscat_s(str, IRIS_NumOfElements(str), temp);

		SetMenuItemInfo(hParentMenu, lpAccel[i].cmd, MF_BYCOMMAND, &mi);
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * ANZ[^̏
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	lpMsg	= bZ[W
 * @return 
*//***********************************************************************/
BOOL CAccelerator::Translate(HWND hWnd, LPMSG lpMsg)
{
#ifdef UNICODE
	return TranslateW(hWnd, lpMsg);
#else
	return TranslateA(hWnd, lpMsg);
#endif
}
/// CAccelerator::Translate Q
BOOL CAccelerator::TranslateA(HWND hWnd, LPMSG lpMsg)
{
	return TranslateAcceleratorA(hWnd, m_hAccel, lpMsg);
}
/// CAccelerator::Translate Q
BOOL CAccelerator::TranslateW(HWND hWnd, LPMSG lpMsg)
{
	return TranslateAcceleratorW(hWnd, m_hAccel, lpMsg);
}

}	// end of namespace wx
}	// end of namespace iris
