//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFTP.h
 * @brief		FTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFTP_H_
#define INCG_IRIS_WXFTP_H_

//======================================================================
// include
#include "WXInetBase.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! FTPNX
class CFTP : public CInetBase
{
public:
	// RXgN^
	CFTP(void);
	CFTP(HINTERNET hConnect);
	// fXgN^
	~CFTP(void);

public:

	// t@C
	HINTERNET	FindFirstFileA(LPCSTR  lpszSearchFile, LPWIN32_FIND_DATAA lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	FindFirstFileW(LPCWSTR lpszSearchFile, LPWIN32_FIND_DATAW lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext=0);

	// [gt@C擾
	BOOL		GetFile (LPCTSTR lpszRemoteFile, LPCTSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		GetFileA(LPCSTR  lpszRemoteFile, LPCSTR  lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		GetFileW(LPCWSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		GetFileEx(LPCSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	// [J烊[g̃t@C]
	BOOL		PutFile (LPCTSTR lpszLocalFile, LPCTSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		PutFileA(LPCSTR  lpszLocalFile, LPCSTR  lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		PutFileW(LPCWSTR lpszLocalFile, LPCWSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		PutFileEx(LPCWSTR lpszLocalFile, LPCSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	// t@C폜
	BOOL		DeleteFileA(LPCSTR  lpszFileName);
	BOOL		DeleteFileW(LPCWSTR lpszFileName);
	// l[
	BOOL		RenameFile (LPCTSTR lpszExisting, LPCTSTR lpszNew);
	BOOL		RenameFileA(LPCSTR  lpszExisting, LPCSTR  lpszNew);
	BOOL		RenameFileW(LPCWSTR lpszExisting, LPCWSTR lpszNew);
	// t@CJ
	HINTERNET	OpenFile (LPCTSTR lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenFileA(LPCSTR  lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenFileW(LPCWSTR lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext=0);


	// fBNg쐬
	BOOL		CreateDirectoryA(LPCSTR  lpszDirectory);
	BOOL		CreateDirectoryW(LPCWSTR lpszDirectory);
	// fBNg폜
	BOOL		RemoveDirectoryA(LPCSTR  lpszDirectory);
	BOOL		RemoveDirectoryW(LPCWSTR lpszDirectory);

	// JgfBNgύX
	BOOL		SetCurrentDirectoryA(LPCSTR  lpszDirectory);
	BOOL		SetCurrentDirectoryW(LPCWSTR lpszDirectory);
	// JgfBNg擾
	BOOL		GetCurrentDirectoryA(LPSTR  lpszDirectory, LPDWORD lpdwSize);
	BOOL		GetCurrentDirectoryW(LPWSTR lpszDirectory, LPDWORD lpdwSize);

	// 
	BOOL		Command (BOOL fExpectResponse, DWORD dwFlags, LPCTSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);
	BOOL		CommandA(BOOL fExpectResponse, DWORD dwFlags, LPCSTR  lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);
	BOOL		CommandW(BOOL fExpectResponse, DWORD dwFlags, LPCWSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);

	// t@CTCY擾
	DWORD		FtpGetFileSize(LPDWORD lpdwFileSizeHigh);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
