//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXBitmap.cpp
 * @brief		BitmapNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXBitmap_CPP_

//======================================================================
// include
#include "WXBitmap.h"
#include "../base/WXError.h"

#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CBitmap::CBitmap(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CBitmap::~CBitmap(void)
{
}

/**********************************************************************//**
 *
 * `(HDC)
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	cx		= SW
 * @param [in]	cy		= SW
 * @param [in]	scale	= XP[
 * @param [in]	rop		= sNZIy[V(SRCCOPY etc...)
 * @return	
*//***********************************************************************/
void CBitmap::Draw(HDC hdc, s32 cx, s32 cy, f32 scale, DWORD rop)
{
	if( !IsValid() ) return;

	s32 dW = (s32)(m_bmp.info->biWidth*scale);
	s32 dH = (s32)(m_bmp.info->biHeight*scale);

	int ret = StretchDIBits(hdc, cx-(dW>>1), cy-(dH>>1), dW, dH
		, 0, 0, GetWidth(), GetHeight()
		, m_bmp.data, (LPBITMAPINFO)m_bmp.info
		, DIB_RGB_COLORS
		, rop);
	if( ret == 0 )
	{
		CScopedLastError e;
		CLastError le(e);
		printf("%d, %s\n", ret, le.ToStringA());
	}
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// class
class CWXBitmapUnitTest : public iris::unit::CUnitTest<CWXBitmapUnitTest>
{
public:
	iris::wx::CBitmap m_bitmap;
};

//======================================================================
// function
static LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// test
IRIS_UNITTEST_FIX(CWXBitmapUnitTest, WXBitmapUnitTest)
{
	CWXBitmapUnitTest* lput = CWXBitmapUnitTest::GetCurrent();

	TCHAR path[MAX_PATH];
	std::cout << "Jbitmapt@C͂ĂB" << std::endl;
	std::tcin >> path;
	wx::CBitmap& bitmap = lput->m_bitmap;

	if( !bitmap.ReadFile(path) ) 
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

#define WINDOW_STYLE	( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX )
#define WINDOW_STYLEEX	( WS_EX_OVERLAPPEDWINDOW )
	HWND hWnd = nullptr;
	TCHAR		Name[]	= TEXT("sample");
	HINSTANCE hInstance = (HINSTANCE)GetModuleHandle(nullptr);
	if( CWindow::RegisterClassEx(0
		, hInstance
		, nullptr
		, LoadCursor( nullptr, IDC_ARROW )
		, (HBRUSH)GetStockObject( BLACK_BRUSH )
		, Name
		, nullptr
		, nullptr
		, WindowProc) == 0 ) return;

	RECT src = {0, 0, lput->m_bitmap.GetWidth(), lput->m_bitmap.GetHeight()};

	// EBhEg̒
	AdjustWindowRectEx(
		&src,
		WINDOW_STYLE,
		FALSE,
		WINDOW_STYLEEX );
	// EBhE̍쐬
	hWnd = CreateWindowEx(
		WINDOW_STYLEEX,
		Name,
		Name,
		WINDOW_STYLE,
		CW_USEDEFAULT,
		0,
		src.right,
		src.bottom,
		nullptr,
		nullptr,
		hInstance,
		nullptr );

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		goto exit;

	// EBhE\
	ShowWindow(hWnd, SW_SHOW);
	// EBhE̍XV
	UpdateWindow(hWnd);
	// őOʂ
	SetForegroundWindow(hWnd);

	// bZ[W[v
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while( GetMessage( &msg, nullptr, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

exit:
	UnregisterClass(Name, hInstance);
}

/**********************************************************************//**
 *
 * eXgpEBhEvV[W
 * 
 ----------------------------------------------------------------------
 * @param	hWnd	EBhEnh
 * @param	uMsg	sꂽbZ[W
 * @param	wParam	sꂽbZ[W@
 * @param	lParam	sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	case WM_PAINT:
		{
			CWXBitmapUnitTest* lput = CWXBitmapUnitTest::GetCurrent();
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hWnd, &ps);
			lput->m_bitmap.Draw(hdc, lput->m_bitmap.GetWidth()/2, lput->m_bitmap.GetHeight()/2, 1.0f, SRCCOPY);
			EndPaint(hWnd, &ps);
		}
		break;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

#endif
