//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDPI.cpp
 * @brief		𑜓x擾NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDPI_CPP_

//======================================================================
// include
#include "WXDPI.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * 𑜓x̎擾ij
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 CDPI::GetHDPI(void)	const
{
	HDC hdc = GetDC(GetDesktopWindow());
	s32 dpi = GetDeviceCaps(hdc, LOGPIXELSX);
	DeleteDC(hdc);
	return dpi;
}

/**********************************************************************//**
 *
 * 𑜓x̎擾icj
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 CDPI::GetVDPI(void)	const
{
	HDC hdc = GetDC(GetDesktopWindow());
	s32 dpi = GetDeviceCaps(hdc, LOGPIXELSY);
	DeleteDC(hdc);
	return dpi;
}

}	// end of namespace wx

namespace fnd
{

//======================================================================
// function
/**********************************************************************//**
 *
 * 𑜓x̎擾ij
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 GetHDPI(void)
{
	wx::CDPI dpi;
	return dpi.GetHDPI();
}

/**********************************************************************//**
 *
 * 𑜓x̎擾icj
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 GetVDPI(void)
{
	wx::CDPI dpi;
	return dpi.GetVDPI();
}

}	// end of namespace fnd

}	// end of namespace iris

