//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWallpaper.h
 * @brief		ǎύXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXWallpaper_H_
#define INCG_IRIS_WXWallpaper_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx 
{

//======================================================================
// enum
/// ǎX^C
typedef enum WALLPAPER_STYLE
{
	eWPSTYLE_CENTER	= 0,	//!< ɕ\
	eWPSTYLE_TILE,			//!< ׂĕ\
	eWPSTYLE_STRETCH,		//!< gkĕ\
	eWPSTYLE_MAX
} WALLPAPER_STYLE;

//======================================================================
// declare
class CActiveDesktop;

//======================================================================
// class
//! ǎύXNX
class CWallpaper : public INonCopyable<>
{
	CActiveDesktop*	m_pAD;

public:
	// RXgN^
	CWallpaper(void);
	// fXgN^
	~CWallpaper(void);

public:
	// ANeBufXNgbv̎gp
	BOOL	CreateActiveDesktop(void);
	// ANeBufXNgbv̉
	void	ReleaseActiveDesktop(void);

public:
	// ǎt@C擾
	BOOL	GetWallpaper (LPTSTR lpszWallpaper, UINT cchWallpaper);
	BOOL	GetWallpaperA(LPSTR  lpszWallpaper, UINT cchWallpaper);
	BOOL	GetWallpaperW(LPWSTR lpszWallpaper, UINT cchWallpaper);

	// ǎt@Cݒ
	BOOL	SetWallpaper (LPCTSTR lpszWallpaper);
	BOOL	SetWallpaperA(LPCSTR  lpszWallpaper);
	BOOL	SetWallpaperW(LPCWSTR lpszWallpaper);

public:
	// X^C擾
	BOOL	GetStyle(LPDWORD lpdwStyle);
	// X^Cݒ
	BOOL	SetStyle(DWORD dwStyle);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
