//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDesktopProfile.h
 * @brief		Desktop.iniNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDesktopProfile_H_
#define INCG_IRIS_WXDesktopProfile_H_

//======================================================================
// include
#include "../../registry/WXMappedProfile.h"

namespace iris {
namespace wx 
{

//======================================================================
// define
#define DESKTOP_PROFILE_APPNAME_IMAGEA		 "{BE098140-A513-11D0-A3A4-00C04FD706EC}"
#define DESKTOP_PROFILE_APPNAME_IMAGEW		L"{BE098140-A513-11D0-A3A4-00C04FD706EC}"
#define DESKTOP_PROFILE_SECNAME_ATTRIBUTESA	 "Attributes"
#define DESKTOP_PROFILE_SECNAME_ATTRIBUTESW	L"Attributes"
#define DESKTOP_PROFILE_SECNAME_IMAGEA		 "IconArea_Image"
#define DESKTOP_PROFILE_SECNAME_IMAGEW		L"IconArea_Image"
#define DESKTOP_PROFILE_SECNAME_COLORA		 "IconArea_Text"
#define DESKTOP_PROFILE_SECNAME_COLORW		L"IconArea_Text"
#define DESKTOP_PROFILE_SECNAME_BKCOLORA	 "IconArea_TextBackground"
#define DESKTOP_PROFILE_SECNAME_BKCOLORW	L"IconArea_TextBackground"

#ifdef UNICODE
#define	DESKTOP_PROFILE_APPNAME_IMAGE			DESKTOP_PROFILE_APPNAME_IMAGEW
#define	DESKTOP_PROFILE_SECNAME_ATTRIBUTES		DESKTOP_PROFILE_SECNAME_ATTRIBUTESW
#define	DESKTOP_PROFILE_SECNAME_IMAGE			DESKTOP_PROFILE_SECNAME_IMAGEW
#define	DESKTOP_PROFILE_SECNAME_COLOR			DESKTOP_PROFILE_SECNAME_COLORW
#define	DESKTOP_PROFILE_SECNAME_BKCOLOR			DESKTOP_PROFILE_SECNAME_BKCOLORW
#else
#define	DESKTOP_PROFILE_APPNAME_IMAGE			DESKTOP_PROFILE_APPNAME_IMAGEA
#define	DESKTOP_PROFILE_SECNAME_ATTRIBUTES		DESKTOP_PROFILE_SECNAME_ATTRIBUTESA
#define	DESKTOP_PROFILE_SECNAME_IMAGE			DESKTOP_PROFILE_SECNAME_IMAGEA
#define	DESKTOP_PROFILE_SECNAME_COLOR			DESKTOP_PROFILE_SECNAME_COLORA
#define	DESKTOP_PROFILE_SECNAME_BKCOLOR			DESKTOP_PROFILE_SECNAME_BKCOLORA
#endif

//======================================================================
// function
// ǂݍ
BOOL	ReadDesktopProfile (LPCTSTR lpszDirectory, LPTSTR lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	ReadDesktopProfileA(LPCSTR  lpszDirectory, LPSTR  lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	ReadDesktopProfileW(LPCWSTR lpszDirectory, LPWSTR lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);

// 
BOOL	WriteDesktopProfile (LPCTSTR lpszDirectory, LPCTSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	WriteDesktopProfileA(LPCSTR  lpszDirectory, LPCSTR  lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	WriteDesktopProfileW(LPCWSTR lpszDirectory, LPCWSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);

// NA
BOOL	ClearDesktopProfile (LPCTSTR lpszDirectory);
BOOL	ClearDesktopProfileA(LPCSTR  lpszDirectory);
BOOL	ClearDesktopProfileW(LPCWSTR lpszDirectory);

//======================================================================
// class
//! DesktopPrivateProfileNX
class CDesktopProfile : public CMappedPrivateProfile
{
private:
	TCHAR	m_ImagePath[MAX_PATH];
	DWORD	m_dwTextColor;
	DWORD	m_dwTextBkColor;
public:
	// RXgN^
	CDesktopProfile(void);
	// fXgN^
	~CDesktopProfile(void);

public:
	// ǂݍ
	BOOL	Read(LPCTSTR lpszDirectory);
	// 
	BOOL	Write(LPCTSTR lpszDirectory);
	// 
	BOOL	Write(LPCTSTR lpszDirectory, bool bImage, bool bColor, bool bBkColor);
	// NA
	BOOL	Clear(LPCTSTR lpszDirectory);

public:
	// get, set
	LPTSTR	GetImagePath(void)				{ return m_ImagePath; }
	LPCTSTR	GetImagePath(void)	const		{ return m_ImagePath; }
	void	SetImagePath(LPCTSTR lpszPath);
	DWORD	GetTextColor(void)				{ return m_dwTextColor; }
	void	SetTextColor(DWORD dwColor)		{ m_dwTextColor = dwColor; }
	DWORD	GetTextBkColor(void)			{ return m_dwTextBkColor; }
	void	SetTextBkColor(DWORD dwColor)	{ m_dwTextBkColor = dwColor; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
