//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHID.h
 * @brief		WXHID t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHID_H_
#define INCG_IRIS_WXHID_H_

//======================================================================
// include
#include "../io/WXHFile.h"
#include "WXSetupDi.h"

#if	defined(_IRIS_SUPPORT_WDK)

//======================================================================
// define 
#ifndef __drv_maxIRQL
#  define __drv_maxIRQL(a)	
#endif
#ifndef __drv_when
#  define __drv_when(a, b)
#endif
#ifndef __drv_freesMem
#  define __drv_freesMem(m)
#endif

//======================================================================
// include
EXTERN_C_BEGIN
#include <hidsdi.h>
EXTERN_C_END

namespace iris {
namespace wx
{

//======================================================================
// class
/// HID NX
class CHID : public CHFile
{
public:
	typedef BOOL	(*ENUMHIDSPROC)(LPCTSTR lpDevicePath, PSP_DEVICE_INTERFACE_DATA pspid, LPVOID lpUser);
public:
	// HID ̗
	static BOOL	EnumHID(ENUMHIDSPROC lpCallback, LPVOID lpUser);
public:
	// ΏۃfoCXǂf
	static bool	IsSpecifiedDevice(LPCTSTR lpDevicePath, USHORT VendorID, USHORT ProductID);

public:
	// RXgN^
	CHID(void);
	// fXgN^
	~CHID(void);

public:
	// ̎擾
	BOOL	GetAttributes(PHIDD_ATTRIBUTES lpAttr);
	// x_[ID ̎擾
	USHORT	GetVendorID(void);
	// v_NgID ̎擾
	USHORT	GetProductID(void);
	// o[W ̎擾
	USHORT	GetVersionNumber(void);

	// VAԍ̎擾
	BOOL	GetSerialNumberString(PVOID lpBuffer, ULONG ulLength);

public:
	// 
	BOOL	GetPreparsedData(PHIDP_PREPARSED_DATA* phpd);

};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
