//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugUnitTest.cpp
 * @brief		P̃eXgT|[gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDebugUnitTest_CPP_
#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

#include "WXDebugUnitTest.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// function
/**********************************************************************//**
 *
 * eXgpEBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK UnitTest_WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	//bZ[W̏
	switch( uMsg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		break;
	case WM_CLOSE:
		DestroyWindow( hWnd );
		break;
	case WM_KEYUP:
		switch( wParam )
		{
		case VK_ESCAPE:
			DestroyWindow( hWnd );
			break;
		}
		break;
	default:
		return DefWindowProc( hWnd, uMsg, wParam, lParam );
		break;
	}
	return 0L;
}

/**********************************************************************//**
 *
 * eXgpEBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	uStyleEx	= gX^C
 * @param [in]	lpClassName	= NX
 * @param [in]	lpWindowName= EBhE
 * @param [in]	uStyle		= X^C
 * @param [in]	nWidth		= 
 * @param [in]	nHeight		= 
 * @param [in]	WndProc		= EBhEvV[W
 * @return	HWND
*//***********************************************************************/
HWND CreateUnitTestWindow(UINT uStyleEx, LPCTSTR lpClassName, LPCTSTR lpWindowName
						  , UINT uStyle, int nWidth, int nHeight
						  , WNDPROC WndProc)
{
	WNDCLASSEX	wcex	= {0};
	HINSTANCE hInstance = (HINSTANCE)GetModuleHandle(nullptr);

	wcex.cbSize			= sizeof( wcex );	// WNDCLASSEX\̂̃TCY
	wcex.style			= 0;				// EBhENX̃X^C
	wcex.lpfnWndProc	= WndProc;			// EBhEvV[W
	wcex.cbClsExtra		= 0;				// gp̃p[^
	wcex.cbWndExtra		= 0;				// gp̃p[^
	wcex.hInstance		= hInstance;		// CX^Xnh
	wcex.hIcon			= nullptr;			// ACR̃nh
	wcex.hCursor		= LoadCursor(nullptr, IDC_ARROW);		// J[\̃nh
	wcex.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);	// wiFݒ
	wcex.lpszMenuName	= nullptr;			// NX̃j[
	wcex.lpszClassName	= lpClassName;		// EBhENX
	wcex.hIconSm		= nullptr;			// X[ACR̃nh

	// EBhENX̓o^
	if( RegisterClassEx( &wcex ) == 0 )
		return 0;

	// EBhE̍쐬
	HWND hWnd = CreateWindowEx(uStyleEx, lpClassName, lpWindowName
		, uStyle, CW_USEDEFAULT, 0, nWidth, nHeight
		, nullptr, nullptr, wcex.hInstance, nullptr );

	ShowWindow(hWnd, SW_SHOW);
	return hWnd;
}

/**********************************************************************//**
 *
 * eXgpC[v
 *
 ----------------------------------------------------------------------
 * @param [in]	func	= R[obN֐
 * @param [in]	arg		= R[obN֐̈
*//***********************************************************************/
void	UnitTestMainLoop(HWND hWnd, void (*func)(void* arg), void* arg)
{
#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
	int cnt=0;
#endif
	// C[v
	MSG msg = {0};
#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
	if( 1 )
#else
	if( func != nullptr ) 
#endif
	{
		while(msg.message != WM_QUIT) 
		{
#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
			if( ++cnt > 5 ) DestroyWindow(hWnd);
#endif

			while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) )
			{
#ifdef _IRIS_SUPPORT_AUTO_UNITTEST
				if( ++cnt > 5 ) DestroyWindow(hWnd);
				if( func != nullptr ) 
#endif
				(*func)(arg);
			}
			if(GetMessage(&msg, nullptr, 0, 0))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
	else
	{
		while(GetMessage(&msg, nullptr, 0, 0)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

