//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackTrace.h
 * @brief		X^bNg[XNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStackTrace_H_
#define INCG_IRIS_WXStackTrace_H_

//======================================================================
// include
#include "WXSymbol.h"
#include "../../os/WXCRTThread.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// class
/// X^bNg[XNX
class CStackTrace : public IIrisObject
{
public:
	/** o͏ */
	typedef struct tagTRACEINFO
	{
		TCHAR	filename[MAX_PATH];	//!< t@C
		TCHAR	funcname[MAX_PATH];	//!< ֐
		int		line;				//!< sԍ
	} TRACEINFO, *LPTRACEINFO;
private:
	HANDLE		m_hCurrentProcess;		//!< JgvZX
	CThread		m_CurrentThread;		//!< JgXbh
	CCRTThread	m_Thread;				//!< Xbh

	PROC		m_pfnDuplicateHandle;	//!< nh֐|C^

	TRACEINFO	m_Info;					//!< ͏

public:
	// RXgN^
	CStackTrace(void);
	// fXgN^
	~CStackTrace(void);

public:
	// g[X
	bool	Trace(int skip);

public:
	/// ͏̎擾
	const TRACEINFO&	GetTraceInfo(void)	const	{ return m_Info; }
	/// t@C̎擾
	LPCTSTR				GetFileName(void)	const	{ return m_Info.filename; }
	/// sԍ̎擾
	int					GetLine(void)		const	{ return m_Info.line; }

private:
	// XbhGg
	UINT	Entry(int skip);
	// g[Xs
	bool	Search(int skip);

private:
	// Gg
	static UINT WINAPI _Entry(void*);
};


}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
