//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXObjLeakCheck.cpp
 * @brief		IuWFNgnh[N`FbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXObjLeakCheck_CPP_

//======================================================================
// include
#include "WXObjLeakCheck.h"

#ifdef _IRIS_DEBUG
#include "WXDebugHelp.h"
#include "fnd/container/FndScopedLock.h"
#include "WXStackTrace.h"
#include "../WXDebugLeakCheckMacro.h"
#include "../../os/WXCriticalSection.h"
#include "../../base/WXError.h"
#include "iris_debug.h"
#include <tchar.h>

namespace iris {
namespace wx {
namespace dbg
{

namespace
{

//======================================================================
// variable
static CObjLeakCheck	s_ObjLeakCheck;

//======================================================================
// struct
typedef struct _tagObjectList
{
	void*	object;
	PROC	close;
	TCHAR	file[MAX_PATH];
	int		line;
	int		count;
	_tagObjectList*	next;
} ObjectList;

//======================================================================
// define
#define APIHOOK_BEGIN()		int i=0;			\
	HMODULE hModule = GetModuleHandle(nullptr);	\
	if( hModule == nullptr ) return false

#define APIHOOK(dll, OriginName)							\
	if( m_##OriginName.OpenA(dll, #OriginName, hModule) )	\
		m_##OriginName.Replace((PROC)Hook_##OriginName)

#define APIHOOK_END()

#define HOOK_FUNC(ret, OriginName, args)			\
	typedef ret (WINAPI *PFN_##OriginName)##args;	\
	CProcHook	m_##OriginName;						\
	static ret	WINAPI Hook_##OriginName##args

#define HOOK_FUNC_NAME(OriginName)	Hook_##OriginName

#define GET_ORIGIN_FUNC(OriginName)	\
	CObjLeakCheckImpl::GetInstance().m_##OriginName.GetOriginProc()

//======================================================================
// class
// NX
class CObjLeakCheckImpl : public IIrisObject
{
	typedef fnd::CScopedLock<CCriticalSection> CCSScopedLock;
	enum
	{
		LIST_CAPACITY	= 256,
	};

protected:
	HANDLE		m_Heap;
	ObjectList*	m_pTop;
	ObjectList*	m_pLast;
	int			m_AllocCount;
	CCriticalSection	m_CS;

public:
	static CObjLeakCheckImpl&	GetInstance(void)	{ static CObjLeakCheckImpl impl; return impl; }
private:
	// RXgN^
	CObjLeakCheckImpl(void)
		: m_pTop(nullptr)
		, m_Heap(nullptr)
		, m_pLast(nullptr)
	{
	}

	// fXgN^
	~CObjLeakCheckImpl(void)
	{
		Terminate();
	}

public:
	// 
	bool	Initialize(void)
	{
		m_AllocCount = 0;

		// Xgpq[v쐬
		m_Heap = HeapCreate(HEAP_GENERATE_EXCEPTIONS, sizeof(ObjectList)*LIST_CAPACITY, 0);
		if( m_Heap == INVALID_HANDLE_VALUE )
		{
			m_Heap = nullptr;
			return false;
		}

		DWORD option = ::SymGetOptions();
		option |= SYMOPT_LOAD_LINES;
		option &= ~SYMOPT_UNDNAME;
		option = ::SymSetOptions(option);

		CHAR modulepath[MAX_PATH];
		::GetModuleFileNameA(GetModuleHandleA(nullptr), modulepath, MAX_PATH);
#if 0
		LPSTR p = strrchr(modulepath, '\\');
		if( p != nullptr ) *p = '\0';
		// V{GW̏
		if( !::SymInitialize(::GetCurrentProcess(), modulepath, TRUE) ) return false;
#else
		if( !::SymInitialize(::GetCurrentProcess(), nullptr, TRUE) ) return false;
#endif
		::SymLoadModule(::GetCurrentProcess(), nullptr, modulepath, nullptr, 0, 0);


		if( !BeginHook() ) 
		{
			return false;
		}
		return true;
	}

	// I
	void	Terminate(void)
	{
		ShowLeakList();

		// V{GW̒~
		::SymCleanup(::GetCurrentProcess());

		Clear();
		if( m_Heap != nullptr )
		{
			HeapDestroy(m_Heap);
			m_Heap = nullptr;
		}
	}

public:
	// Xgɒǉ
	void	Add(void* lpObject, PROC pfnClose)
	{
		CStackTrace st;

		CScopedLastError e;
		IRIS_ASSERT(m_Heap != nullptr);
		ObjectList* p = (ObjectList*)(HeapAlloc(m_Heap, 0, sizeof(ObjectList)));
		if( p == nullptr )
		{
			IRIS_WARNING("memory alloc failed.");
			return;
		}

		if( st.Trace(5) )
		{
			_tcscpy_s(p->file, MAX_PATH, st.GetFileName());
			p->line = st.GetLine();
		}
		else
		{
			p->file[0] = '\0';
			p->line = -1;
		}
		p->close = pfnClose;
		p->object = lpObject;
		p->count = m_AllocCount++;
		p->next = nullptr;

		CCSScopedLock lock(m_CS);

		if( m_pTop != nullptr )
		{
			IRIS_ASSERT( m_pLast != nullptr );
			m_pLast->next = p;
		}
		else
		{
			IRIS_ASSERT( m_pLast == nullptr );
			m_pTop = p;
		}
		m_pLast = p;
	}
	// Xg폜
	void	Remove(void* lpObject, PROC pfnClose)
	{
		CScopedLastError e;
		CCSScopedLock lock(m_CS);

		ObjectList* pre = nullptr;
		ObjectList* p = m_pTop;
		while(p != nullptr)
		{
			if( p->object == lpObject && p->close == pfnClose )
			{
				break;
			}
			pre = p;
			p = p->next;
		}
		if( p == nullptr )
		{
			return;
		}
		if( pre == nullptr )
		{
			IRIS_ASSERT( m_pTop == p );
			m_pTop = p->next;
			if( m_pLast == p )
			{
				m_pLast = p->next;
				IRIS_ASSERT( m_pLast == nullptr );
			}
		}
		else
		{
			pre->next = p->next;
			if( m_pLast == p )
			{
				m_pLast = pre;
				IRIS_ASSERT( pre->next == nullptr );
			}
		}
		HeapFree(m_Heap, 0, p);
	}


private:
	// XgNA
	void	Clear(void)
	{
		CCSScopedLock lock(m_CS);
		ObjectList* pre = nullptr;
		ObjectList* p = m_pTop;

		while(p != nullptr)
		{
			pre = p;
			p = p->next;
			HeapFree(m_Heap, 0, pre);
		}
		m_pTop = nullptr;
	}

	// [NXg̏o
	void	ShowLeakList(void)
	{
		CCSScopedLock lock(m_CS);
		ObjectList* p = m_pTop;
		if( m_pTop != nullptr )
		{
			dbgoutputA("---------- OBJECT Leak!! ----------\r\n");
			while( p != nullptr )
			{
				CHAR buffer[1024];
				wsprintfA(buffer, "%s(%d) : [%d] Object=0x%p\r\n", p->file, p->line, p->count, p->object);
				dbgoutputA(buffer);
				p = p->next;
			}
			dbgoutputA("-----------------------------------\r\n");
		}
	}


private:
	// tbNJn
	bool	BeginHook(void)
	{
		APIHOOK_BEGIN();

		APIHOOK("kernel32.dll", OpenEventA);
		APIHOOK("kernel32.dll", CreateEventA);
		APIHOOK("kernel32.dll", CreateProcessA);
		//APIHOOK("kernel32.dll", CreateFileA);
		//APIHOOK("kernel32.dll", CreateFileMappingA);
		//APIHOOK("kernel32.dll", OpenFileMappingA);
		//APIHOOK("kernel32.dll", CreateThread);
		//APIHOOK("kernel32.dll", CreateMutexA);
		//APIHOOK("kernel32.dll", OpenMutexA);
		//APIHOOK("kernel32.dll", CreateSemaphoreA);
		//APIHOOK("kernel32.dll", OpenSemaphoreA);
		//APIHOOK("kernel32.dll", CreateNamedPipeA);
		//APIHOOK("kernel32.dll", CreatePipe);
		//APIHOOK("kernel32.dll", FindFirstFileA);
		//APIHOOK("kernel32.dll", FindClose);
		//APIHOOK("kernel32.dll", CreateToolhelp32Snapshot);

		//APIHOOK("kernel32.dll", RegOpenKeyExA);
		//APIHOOK("kernel32.dll", RegOpenKeyA);
		//APIHOOK("kernel32.dll", RegConnectRegistryA);
		//APIHOOK("kernel32.dll", RegCloseKey);
		//APIHOOK("kernel32.dll", RegCreateKeyExA);
		//APIHOOK("kernel32.dll", RegCreateKeyA);

		APIHOOK("kernel32.dll", CloseHandle);

		APIHOOK_END();
		return true;
	}

protected:
	// tbN֐`
	HOOK_FUNC(HANDLE, OpenEventA	, (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName))
	{
		HANDLE hdle = ((PFN_OpenEventA)GET_ORIGIN_FUNC(OpenEventA))(dwDesiredAccess, bInheritHandle, lpName);
		if( hdle != nullptr && hdle != INVALID_HANDLE_VALUE )
		{
			CObjLeakCheckImpl::GetInstance().Add(hdle, GET_ORIGIN_FUNC(CloseHandle));
		}
		return hdle;
	}

	HOOK_FUNC(HANDLE, CreateEventA	, (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCSTR lpName))
	{
		HANDLE hdle = ((PFN_CreateEventA)GET_ORIGIN_FUNC(CreateEventA))(lpEventAttributes, bManualReset, bInitialState, lpName);
		if( hdle != nullptr && hdle != INVALID_HANDLE_VALUE )
		{
			CObjLeakCheckImpl::GetInstance().Add(hdle, GET_ORIGIN_FUNC(CloseHandle));
		}
		return hdle;
	}

	HOOK_FUNC(HANDLE, CreateProcessA , (LPCSTR lpApplicationName, LPSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes
		, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment
		, LPCSTR lpCurrentDirectory, LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation))
	{
		HANDLE hdle = ((PFN_CreateProcessA)GET_ORIGIN_FUNC(CreateEventA))(lpApplicationName, lpCommandLine, lpProcessAttributes
			, lpThreadAttributes, bInheritHandles, dwCreationFlags, lpEnvironment
			, lpCurrentDirectory, lpStartupInfo, lpProcessInformation);
		if( hdle != nullptr && hdle != INVALID_HANDLE_VALUE )
		{
			CObjLeakCheckImpl::GetInstance().Add(hdle, GET_ORIGIN_FUNC(CloseHandle));
		}
		return hdle;
	}

	HOOK_FUNC(BOOL	, CloseHandle	, (HANDLE hObject))
	{
		BOOL ret = ((PFN_CloseHandle)GET_ORIGIN_FUNC(CloseHandle))(hObject);
		if( ret )
		{
			CObjLeakCheckImpl::GetInstance().Remove(hObject, GET_ORIGIN_FUNC(CloseHandle));
		}
		return ret;
	}

};

}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CObjLeakCheck::CObjLeakCheck(void)
{
	CObjLeakCheckImpl::GetInstance().Initialize();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CObjLeakCheck::~CObjLeakCheck(void)
{
	CObjLeakCheckImpl::GetInstance().Terminate();
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
