//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugHelp.cpp
 * @brief		dbghelp t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDebugHelp_CPP_

//======================================================================
// include
#include "WXDebugHelp.h"
#include "../../os/WXModule.h"
#include "iris_iostream.h"

#if 1
//======================================================================
// link
#pragma	comment(lib,"dbghelp.lib")

#else

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// declare
class CDbgHelp;

//======================================================================
// static
namespace {
static CDbgHelp*	s_pDbgHelp = nullptr;
}

//======================================================================
// class
// dbghelp NX
class CDbgHelp : public IIrisObject
{
	CModule	m_Module;
public:
	// RXgN^
	CDbgHelp(void)
	{
		s_pDbgHelp = this;
	}
	// fXgN^
	~CDbgHelp(void)
	{
		s_pDbgHelp = nullptr;
	}

public:
	// CX^X̎擾
	static CDbgHelp&	GetInstance(void)		{ static CDbgHelp instance; return instance; }
	static CDbgHelp*	GetInstancePtr(void)	{ CDbgHelp& instance = GetInstance(); return s_pDbgHelp; }

public:
	// [h
	bool	Load(void)
	{
		if( m_Module.IsValid() ) return true;
		return IRIS_TO_bool( m_Module.Load(TEXT("dbghelp.dll")) );
	}

public:
#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		Load();										\
		pfnProc = reinterpret_cast<pfn##_name>(m_Module.GetProcAddress(#_name));	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

	BOOL SymInitialize(HANDLE hProcess, PCSTR UserSearchPath, BOOL fInvadeProcess)
	{
		PROC_LOAD(BOOL, SymInitialize, (HANDLE hProcess, PCSTR UserSearchPath, BOOL fInvadeProcess), FALSE);
		return pfnProc(hProcess, UserSearchPath, fInvadeProcess);
	}
	BOOL SymCleanup(HANDLE hProcess)
	{
		PROC_LOAD(BOOL, SymCleanup, (HANDLE hProcess), FALSE);
		return pfnProc(hProcess);
	}
	DWORD SymLoadModule(HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, DWORD BaseOfDll, DWORD SizeOfDll)
	{
		PROC_LOAD(DWORD, SymLoadModule, (HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, DWORD BaseOfDll, DWORD SizeOfDll), 0);
		return pfnProc(hProcess, hFile, ImageName, ModuleName, BaseOfDll, SizeOfDll);
	}
	BOOL SymUnloadModule(HANDLE hProcess, DWORD BaseOfDll)
	{
		PROC_LOAD(BOOL, SymUnloadModule, (HANDLE hProcess, DWORD BaseOfDll), FALSE);
		return pfnProc(hProcess, BaseOfDll);
	}
	BOOL SymSetSearchPath(HANDLE hProcess, PCSTR SearchPath)
	{
		PROC_LOAD(BOOL, SymSetSearchPath, (HANDLE hProcess, PCSTR SearchPath), FALSE);
		return pfnProc(hProcess, SearchPath);
	}
	BOOL SymGetSearchPath(HANDLE hProcess, PSTR SearchPath, DWORD SearchPathLength)
	{
		PROC_LOAD(BOOL, SymGetSearchPath, (HANDLE hProcess, PSTR SearchPath, DWORD SearchPathLength), FALSE);
		return pfnProc(hProcess, SearchPath, SearchPathLength);
	}
	BOOL SymRegisterCallback(HANDLE hProcess, PSYMBOL_REGISTERED_CALLBACK CallbackFunction, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymRegisterCallback, (HANDLE hProcess, PSYMBOL_REGISTERED_CALLBACK CallbackFunction, PVOID UserContext), FALSE);
		return pfnProc(hProcess, CallbackFunction, UserContext);
	}
	BOOL SymRegisterFunctionEntryCallback(HANDLE hProcess, PSYMBOL_FUNCENTRY_CALLBACK CallbackFunction, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymRegisterFunctionEntryCallback, (HANDLE hProcess, PSYMBOL_FUNCENTRY_CALLBACK CallbackFunction, PVOID UserContext), FALSE);
		return pfnProc(hProcess, CallbackFunction, UserContext);
	}
	DWORD SymSetOptions(DWORD SymOptions)
	{
		PROC_LOAD(DWORD, SymSetOptions, (DWORD SymOptions), 0);
		return pfnProc(SymOptions);
	}
	DWORD SymGetOptions(void)
	{
		PROC_LOAD(DWORD, SymGetOptions, (), 0);
		return pfnProc();
	}
	BOOL SymGetSymPrev(HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol)
	{
		PROC_LOAD(BOOL, SymGetSymPrev, (HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol), FALSE);
		return pfnProc(hProcess, Symbol);
	}
	BOOL SymGetSymNext(HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol)
	{
		PROC_LOAD(BOOL, SymGetSymNext, (HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol), FALSE);
		return pfnProc(hProcess, Symbol);
	}
	BOOL SymGetSymFromName(HANDLE hProcess, PCSTR Name, PIMAGEHLP_SYMBOL Symbol)
	{
		PROC_LOAD(BOOL, SymGetSymFromName, (HANDLE hProcess, PCSTR Name, PIMAGEHLP_SYMBOL Symbol), FALSE);
		return pfnProc(hProcess, Name, Symbol);
	}
	BOOL SymGetSymFromAddr(HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_SYMBOL Symbol)
	{
		PROC_LOAD(BOOL, SymGetSymFromAddr, (HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_SYMBOL Symbol), FALSE);
		return pfnProc(hProcess, dwAddr, pdwDisplacement, Symbol);
	}
	BOOL SymGetLinePrev(HANDLE hProcess, PIMAGEHLP_LINE Line)
	{
		PROC_LOAD(BOOL, SymGetLinePrev, (HANDLE hProcess, PIMAGEHLP_LINE Line), FALSE);
		return pfnProc(hProcess, Line);
	}
	BOOL SymGetLineNext(HANDLE hProcess, PIMAGEHLP_LINE Line)
	{
		PROC_LOAD(BOOL, SymGetLineNext, (HANDLE hProcess, PIMAGEHLP_LINE Line), FALSE);
		return pfnProc(hProcess, Line);
	}
	BOOL SymGetLineFromName(HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PIMAGEHLP_LINE Line)
	{
		PROC_LOAD(BOOL, SymGetLineFromName, (HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PIMAGEHLP_LINE Line), FALSE);
		return pfnProc(hProcess, ModuleName, FileName, dwLineNumber, plDisplacement, Line);
	}
	BOOL SymGetLineFromAddr(HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE Line)
	{
		PROC_LOAD(BOOL, SymGetLineFromAddr, (HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE Line), FALSE);
		return pfnProc(hProcess, dwAddr, pdwDisplacement, Line);
	}
	BOOL SymGetModuleInfo(HANDLE hProcess, DWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo)
	{
		PROC_LOAD(BOOL, SymGetModuleInfo, (HANDLE hProcess, DWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo), FALSE);
		return pfnProc(hProcess, dwAddr, ModuleInfo);
	}
	DWORD SymGetModuleBase(HANDLE hProcess, DWORD dwAddr)
	{
		PROC_LOAD(DWORD, SymGetModuleBase, (HANDLE hProcess, DWORD dwAddr), 0);
		return pfnProc(hProcess, dwAddr);
	}
	PVOID SymFunctionTableAccess(HANDLE hProcess, DWORD AddrBase)
	{
		PROC_LOAD(PVOID, SymFunctionTableAccess, (HANDLE hProcess, DWORD AddrBase), NULL);
		return pfnProc(hProcess, AddrBase);
	}
	BOOL SymEnumerateSymbols(HANDLE hProcess, ULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymEnumerateSymbols, (HANDLE hProcess, ULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext), FALSE);
		return pfnProc(hProcess, BaseOfDll, EnumSymbolsCallback, UserContext);
	}
	BOOL SymEnumerateModules(HANDLE hProcess, PSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext)
	{
		PROC_LOAD(BOOL, SymEnumerateSymbols, (HANDLE hProcess, PSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext), FALSE);
		return pfnProc(hProcess, EnumModulesCallback, UserContext);
	}
	BOOL StackWalk(DWORD MachineType, HANDLE hProcess, HANDLE hThread, LPSTACKFRAME StackFrame, PVOID ContextRecord
		, PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
	{
		PROC_LOAD(BOOL, StackWalk, (DWORD MachineType, HANDLE hProcess, HANDLE hThread, LPSTACKFRAME StackFrame, PVOID ContextRecord
		, PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
		, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
		, FALSE);
		return pfnProc(MachineType, hProcess, hThread, StackFrame, ContextRecord
			, ReadMemoryRoutine, FunctionTableAccessRoutine, GetModuleBaseRoutine, TranslateAddress);
	}
	PVOID ImageDirectoryEntryToData(PVOID Base, BOOLEAN MappedAsImage, USHORT DirectoryEntry, PULONG Size)
	{
		PROC_LOAD(PVOID, ImageDirectoryEntryToData, (PVOID Base, BOOLEAN MappedAsImage, USHORT DirectoryEntry, PULONG Size), NULL);
		return pfnProc(Base, MappedAsImage, DirectoryEntry, Size);
	}
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

using namespace iris;
using namespace wx;
using namespace dbg;

//======================================================================
// import
BOOL WINAPI SymInitialize(HANDLE hProcess, PCSTR UserSearchPath, BOOL fInvadeProcess)
{
	return CDbgHelp::GetInstance().SymInitialize(hProcess, UserSearchPath, fInvadeProcess);
}
BOOL WINAPI SymCleanup(HANDLE hProcess)
{
	if( CDbgHelp::GetInstancePtr() == nullptr ) return FALSE;
	return CDbgHelp::GetInstance().SymCleanup(hProcess);
}
DWORD WINAPI SymLoadModule(HANDLE hProcess, HANDLE hFile, PCSTR ImageName, PCSTR ModuleName, DWORD BaseOfDll, DWORD SizeOfDll)
{
	return CDbgHelp::GetInstance().SymLoadModule(hProcess, hFile, ImageName, ModuleName, BaseOfDll, SizeOfDll);
}
BOOL WINAPI SymUnloadModule(HANDLE hProcess, DWORD BaseOfDll)
{
	return CDbgHelp::GetInstance().SymUnloadModule(hProcess, BaseOfDll);
}
BOOL WINAPI SymSetSearchPath(HANDLE hProcess, PCSTR SearchPath)
{
	return CDbgHelp::GetInstance().SymSetSearchPath(hProcess, SearchPath);
}
BOOL WINAPI SymGetSearchPath(HANDLE hProcess, PSTR SearchPath, DWORD SearchPathLength)
{
	return CDbgHelp::GetInstance().SymGetSearchPath(hProcess, SearchPath, SearchPathLength);
}
BOOL WINAPI SymRegisterCallback(HANDLE hProcess, PSYMBOL_REGISTERED_CALLBACK CallbackFunction, PVOID UserContext)
{
	return CDbgHelp::GetInstance().SymRegisterCallback(hProcess, CallbackFunction, UserContext);
}
BOOL WINAPI SymRegisterFunctionEntryCallback(HANDLE hProcess, PSYMBOL_FUNCENTRY_CALLBACK CallbackFunction, PVOID UserContext)
{
	return CDbgHelp::GetInstance().SymRegisterFunctionEntryCallback(hProcess, CallbackFunction, UserContext);
}
DWORD WINAPI SymSetOptions(DWORD SymOptions)
{
	return CDbgHelp::GetInstance().SymSetOptions(SymOptions);
}
DWORD WINAPI SymGetOptions(void)
{
	return CDbgHelp::GetInstance().SymGetOptions();
}
BOOL WINAPI SymGetSymPrev(HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol)
{
	return CDbgHelp::GetInstance().SymGetSymPrev(hProcess, Symbol);
}
BOOL WINAPI SymGetSymNext(HANDLE hProcess, PIMAGEHLP_SYMBOL Symbol)
{
	return CDbgHelp::GetInstance().SymGetSymNext(hProcess, Symbol);
}
BOOL WINAPI SymGetSymFromName(HANDLE hProcess, PCSTR Name, PIMAGEHLP_SYMBOL Symbol)
{
	return CDbgHelp::GetInstance().SymGetSymFromName(hProcess, Name, Symbol);
}
BOOL WINAPI SymGetSymFromAddr(HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_SYMBOL Symbol)
{
	return CDbgHelp::GetInstance().SymGetSymFromAddr(hProcess, dwAddr, pdwDisplacement, Symbol);
}
BOOL WINAPI SymGetLinePrev(HANDLE hProcess, PIMAGEHLP_LINE Line)
{
	return CDbgHelp::GetInstance().SymGetLinePrev(hProcess, Line);
}
BOOL WINAPI SymGetLineNext(HANDLE hProcess, PIMAGEHLP_LINE Line)
{
	return CDbgHelp::GetInstance().SymGetLineNext(hProcess, Line);
}
BOOL WINAPI SymGetLineFromName(HANDLE hProcess, PCSTR ModuleName, PCSTR FileName, DWORD dwLineNumber, PLONG plDisplacement, PIMAGEHLP_LINE Line)
{
	return CDbgHelp::GetInstance().SymGetLineFromName(hProcess, ModuleName, FileName, dwLineNumber, plDisplacement, Line);
}
BOOL WINAPI SymGetLineFromAddr(HANDLE hProcess, DWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE Line)
{
	return CDbgHelp::GetInstance().SymGetLineFromAddr(hProcess, dwAddr, pdwDisplacement, Line);
}
BOOL WINAPI SymGetModuleInfo(HANDLE hProcess, DWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo)
{
	return CDbgHelp::GetInstance().SymGetModuleInfo(hProcess, dwAddr, ModuleInfo);
}
DWORD WINAPI SymGetModuleBase(HANDLE hProcess, DWORD dwAddr)
{
	return CDbgHelp::GetInstance().SymGetModuleBase(hProcess, dwAddr);
}
PVOID WINAPI SymFunctionTableAccess(HANDLE hProcess, DWORD AddrBase)
{
	return CDbgHelp::GetInstance().SymFunctionTableAccess(hProcess, AddrBase);
}
BOOL WINAPI SymEnumerateSymbols(HANDLE hProcess, ULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK EnumSymbolsCallback, PVOID UserContext)
{
	return CDbgHelp::GetInstance().SymEnumerateSymbols(hProcess, BaseOfDll, EnumSymbolsCallback, UserContext);
}
BOOL WINAPI SymEnumerateModules(HANDLE hProcess, PSYM_ENUMMODULES_CALLBACK EnumModulesCallback, PVOID UserContext)
{
	return CDbgHelp::GetInstance().SymEnumerateModules(hProcess, EnumModulesCallback, UserContext);
}
BOOL WINAPI StackWalk(DWORD MachineType, HANDLE hProcess, HANDLE hThread, LPSTACKFRAME StackFrame, PVOID ContextRecord
	, PREAD_PROCESS_MEMORY_ROUTINE ReadMemoryRoutine, PFUNCTION_TABLE_ACCESS_ROUTINE FunctionTableAccessRoutine
	, PGET_MODULE_BASE_ROUTINE GetModuleBaseRoutine, PTRANSLATE_ADDRESS_ROUTINE TranslateAddress)
{
	return CDbgHelp::GetInstance().StackWalk(MachineType, hProcess, hThread, StackFrame, ContextRecord
			, ReadMemoryRoutine, FunctionTableAccessRoutine, GetModuleBaseRoutine, TranslateAddress);
}
PVOID WINAPI ImageDirectoryEntryToData(PVOID Base, BOOLEAN MappedAsImage, USHORT DirectoryEntry, PULONG Size)
{
	return CDbgHelp::GetInstance().ImageDirectoryEntryToData(Base, MappedAsImage, DirectoryEntry, Size);
}

#endif

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool DumpDllFunctionName(HMODULE hModule)
{
	ULONG	nSize;
	char**	ppszFunctionName;
	WORD*	pwFunctionOrdinal;
	IMAGE_EXPORT_DIRECTORY*	pImageExportDir;
	pImageExportDir = (IMAGE_EXPORT_DIRECTORY*)::ImageDirectoryEntryToData(
		(PVOID)hModule,
		TRUE,
		IMAGE_DIRECTORY_ENTRY_EXPORT,
		&nSize);
	if(pImageExportDir == NULL)
	{
		return false;
	}

	//pImageExportDir̃AhXhModulȇΓIȃAhX
	ppszFunctionName	= (char**)(pImageExportDir->AddressOfNames + (ULONGLONG)hModule);
	pwFunctionOrdinal	= (WORD*)(pImageExportDir->AddressOfNameOrdinals + (ULONGLONG)hModule);

	std::cout.setf( std::ios::hex );
	for(DWORD i = 0; i < pImageExportDir->NumberOfFunctions; i++)
	{
		std::cout.setf( std::ios::dec );
		std::cout << "F" << pImageExportDir->Base + i ;
		std::cout.unsetf( std::ios::dec );
		std::cout << "(0x" << pImageExportDir->Base + i << "j";

		for(DWORD j = 0; j < pImageExportDir->NumberOfNames; j++)
		{
			if(pwFunctionOrdinal[j] != i)		// pwFunctionOrdinal[j]͏ł͂ȂCfbNX
				continue;

			// hModulȇ΃AhXŊ֐i[Ă
			std::cout << "@֐F" << (char*)(ppszFunctionName[j] + (ULONGLONG)hModule) << std::endl;
			break;
		}
	}
	return true;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
#include "unit/UnitCore.h"
#include "../../os/WXModule.h"
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDebugHelpUnitTest, WXDebugHelpUnitTest)
{
	printf("dll̃pX͂ĂB\n");
	CHAR path[MAX_PATH];
	std::cin >> path;
	
	CModule module;
	if( !module.LoadA(path) ) return;

	DumpDllFunctionName(module);

}

#endif
