//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugConsole.cpp
 * @brief		fobOpR\[o͊֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDebugConsole_CPP_
#ifdef _IRIS_DEBUG

//======================================================================
// include
#include "WXDebugConsole.h"
#include "../wx_inchead.h"
#include <string>
#include <tchar.h>

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// variable
static CDebugConsole	s_DbgConsole;

//======================================================================
// function

/**********************************************************************//**
 *
 * fobOpR\[NX擾
 *
 ----------------------------------------------------------------------
 * @return	fobOpR\[NX|C^
*//***********************************************************************/
CDebugConsole*	GetDebugConsole(void)
{
	return &s_DbgConsole;
}

/**********************************************************************//**
 *
 * fobOpR\[J
 *
 ----------------------------------------------------------------------
 * @param [in]	std = std::cout, std::cin̏óE͕ύXsǂ
 * @return	
*//***********************************************************************/
bool DebugConsoleOpen(bool page_sys, bool std)
{
	return s_DbgConsole.Open(page_sys, std);
}

/**********************************************************************//**
 *
 * fobOpR\[
 *
*//***********************************************************************/
void DebugConsoleClose(void)
{
	s_DbgConsole.Close();
}

/**********************************************************************//**
 *
 * o
 *
 -----------------------------------------------------------------------
 * @param [in]	format	= o͕
 * @param [in]	...		= 
*//***********************************************************************/
void out(LPCTSTR format, ... )
{
	va_list	va;
	va_start(va, format);
	s_DbgConsole.Print(format, va);
	va_end(va);
}
void outA(LPCSTR format, ... )
{
	va_list	va;
	va_start(va, format);
	s_DbgConsole.PrintA(format, va);
	va_end(va);
}
void outW(LPCWSTR format, ... )
{
	va_list	va;
	va_start(va, format);
	s_DbgConsole.PrintW(format, va);
	va_end(va);
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDebugConsole::CDebugConsole(void)
: m_Event(nullptr)
, m_bPageSys(false)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDebugConsole::~CDebugConsole(void)
{
}

/**********************************************************************//**
 *
 * R\[J
 *
 -----------------------------------------------------------------------
 * @param [in]	page_sys	= y[WVXegp邩ǂ
 * @param [in]	std			= std::cout, std::cin̏óE͕ύXsǂ
 * @return	
*//***********************************************************************/
bool CDebugConsole::Open(bool page_sys, bool std)
{
	m_Ref.AddRef();
	if( GetConsoleHandle() != nullptr ) return true;
	bool ret = CConsole::Open(std);
	if( page_sys ) 
	{
		if( AddCtrlHandler(CtrlEventHandler) )
		{
			PutsHelp();
			Print(TEXT("********************************************\n"));
			m_bPageSys = true;
		}
	}
	return ret;
}

/**********************************************************************//**
 *
 * R\[
 *
*//***********************************************************************/
void CDebugConsole::Close(void)
{
	m_Ref.SubRef();
	if( m_Ref.GetRef() == 0 )
	{
		if( m_bPageSys ) DelCtrlHandler(CtrlEventHandler);
		m_bPageSys = false;
	}
	CConsole::Close();
}

/**********************************************************************//**
 *
 * wvo
 *
*//***********************************************************************/
void CDebugConsole::PutsHelp(void)
{
	Print(	TEXT("*** iris WXDebugConsole System HELP. ***\n")
			TEXT("Command.\n")
			TEXT("Ctrl+C     : It shifts to the input mode.\n")
			TEXT("\n")
			TEXT("Input Event\n")
			TEXT("setpage=%%d : The console buffer is switched.\n")
			TEXT("addpage=%%d : The console buffer is added.The numerical value is ID.\n")
			TEXT("delpage=%%d : The console buffer is deleted.\n")
			TEXT("help       : Help is displayed.\n")
			TEXT("quite      : The program is ended.\n")
			);
}

/**********************************************************************//**
 *
 * ͑҂
 *
*//***********************************************************************/
void CDebugConsole::WaitInput(void)
{
	TCHAR buf[256];
	DWORD dwRead;
#if 1
	// obt@NA
	FlushInputBuffer();
	Print(_TEXT("> "));
#endif
	ReadConsole(buf, IRIS_NumOfElements(buf), &dwRead);
	// ftHgCxg
	if( !DefaultEvent(buf,dwRead) )
	{
		if( m_Event != nullptr ) (*m_Event)(buf, dwRead);
	}
}

/**********************************************************************//**
 *
 * ͑҂
 *
 ----------------------------------------------------------------------
 * @param [in]	buf		= ̓obt@
 * @param [in]	dwSize	= ̓obt@TCY
 * @return	ꍇtrue
*//***********************************************************************/
bool CDebugConsole::DefaultEvent(LPCTSTR buf, DWORD dwSize)
{
	IRIS_UNUSED_VARIABLE(dwSize);
	LPCTSTR p = _tcsstr(buf, TEXT("setpage="));
	if( p == buf )
	{
		// y[WύX
		p += 8;
		int no = _tcstol(p, nullptr, 0);
		if( SetPage(no) )
		{
			Print(TEXT("set page. %d\n"), no);
		}
		return true;
	}
	p = _tcsstr(buf, TEXT("addpage="));
	if( p == buf )
	{
		// y[Wǉ
		p += 8;
		int no = _tcstol(p, nullptr, 0);
		if( AddPage(no, GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, nullptr) )
		{
			Print(TEXT("addpage succeed. %d\n"), no);
		}
		return true;
	}
	p = _tcsstr(buf, TEXT("delpage="));
	if( p == buf )
	{
		// y[W폜
		p += 8;
		int no = _tcstol(p, nullptr, 0);
		if( DelPage(no) )
		{
			Print(TEXT("delpage succeed. %d\n"), no);
		}
		return true;
	}
	p = _tcsstr(buf, TEXT("quite"));
	if( p == buf )
	{
		SetCtrlHandler(CtrlEventHandler, 0);
		// I
		GenerateConsoleCtrlEvent(CTRL_C_EVENT, 0);
		return true;
	}

	p = _tcsstr(buf, TEXT("help"));
	if( p == buf )
	{
		PutsHelp();
		return false;
	}
	return false;
}

/**********************************************************************//**
 *
 * R\[Cxgnh
 *
 ----------------------------------------------------------------------
 * @param [in]	CtrlType	= CTRL_***_EVENT
 * @return	ȍ~̃CxgnhȂƂ́ATRUEԂ
*//***********************************************************************/
BOOL WINAPI CDebugConsole::CtrlEventHandler(DWORD CtrlType)
{
	switch( CtrlType )
	{
	case CTRL_C_EVENT:
	//case CTRL_BREAK_EVENT:
		// Ctrl + C
		// ͑ҋ@CxgƂ
		s_DbgConsole.WaitInput();
		return 1;
	default:
		break;
	}
	return 0;
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif

