//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcessWindows.cpp
 * @brief		vZXEBhEnhXgNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXProcessWindows_CPP_

//======================================================================
// include
#include "WXProcessWindows.h"
#include "iris_debug.h"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CProcessWindows::CProcessWindows(void)
: m_dwProcessId(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CProcessWindows::~CProcessWindows(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	hParent		= eEBhEnh(nullptr)
 * @param [in]	dwFindFlags	= tO
 * @param [in]	dwProcessId	= ΏۃvZXID
*//***********************************************************************/
void CProcessWindows::Initialize(HWND hParent, DWORD dwFindFlags, DWORD dwProcessId)
{
	_Base::Initialize(hParent, dwFindFlags);
	m_dwProcessId = dwProcessId;
}

/**********************************************************************//**
 *
 * 񋓃R[obN֐
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= qbgEBhEnh
 * @param [in]	lParam	= CProcessWindows*
 * @retval	TRUE	= s
 * @retval	FALSE	= I
*//***********************************************************************/
BOOL CALLBACK CProcessWindows::_EnumWindowsProc(HWND hWnd, LPARAM lParam)
{
	IRIS_ASSERT( lParam != 0 );
	CProcessWindows* p = reinterpret_cast<CProcessWindows*>(lParam);
	DWORD dwProcessID = 0;
	::GetWindowThreadProcessId(hWnd, &dwProcessID);
	if( p->m_dwProcessId == dwProcessID )
	{
		p->m_Map.insert(PAIR(::GetDlgCtrlID(hWnd), hWnd));
		if( p->m_dwFlags & FIND_RECURSION )
		{
			// qEBhE
			::EnumChildWindows(hWnd, _EnumChildWindowsProc, lParam);
		}
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 񋓃R[obN֐
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= qbgEBhEnh
 * @param [in]	lParam	= CProcessWindows*
 * @retval	TRUE	= s
 * @retval	FALSE	= I
*//***********************************************************************/
BOOL CALLBACK CProcessWindows::_EnumChildWindowsProc(HWND hWnd, LPARAM lParam)
{
	IRIS_ASSERT( lParam != 0 );
	CProcessWindows* p = reinterpret_cast<CProcessWindows*>(lParam);
	DWORD dwProcessID = 0;
	::GetWindowThreadProcessId(hWnd, &dwProcessID);
	if( !(p->m_dwFlags & FIND_RECURSION) )
	{
		if( p->m_hParent != ::GetParent(hWnd) ) return TRUE;
	}
	if( p->m_dwProcessId == dwProcessID )
	{
		p->m_Map.insert(PAIR(::GetDlgCtrlID(hWnd), hWnd));
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris_using.h"

TEST(CProcessWindowsTest, Function)
{
	CProcessWindows pwl;
	pwl.Initialize(nullptr, CProcessWindows::FIND_RECURSION, ::GetCurrentProcessId());
	pwl.Update();

#if	defined(_IRIS_SUPPORT_MULTI_UNITTEST_GUI)
	ASSERT_EQ( 1, pwl.Count(1001)  );
#else
	ASSERT_EQ( 0, pwl.Count(1001) );
#endif
}

#endif
