//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXListView.cpp
 * @brief		ListViewt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXListView_CPP_

//======================================================================
// include
#include "WXListView.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * LB_ADDFILE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/

//======================================================================
// class
// CListView
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CListView::CListView(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CListView::CListView(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CListView::~CListView(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListView::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_LISTVIEW
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListView::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_LISTVIEW
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListView::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_LISTVIEW
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListView::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_LISTVIEW
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 * @internal
 *
 * EBhEvV[W
 *
*//***********************************************************************/
LRESULT CListView::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 * @name	bp[֐
 * @{
*//***********************************************************************/
BOOL		CListView::ApproximateViewRect(int nWidth, int nHeight, int nCount)				{ return ListView_ApproximateViewRect(m_hWnd, nWidth, nHeight, nCount); }
BOOL		CListView::Arrange(UINT code)													{ return ListView_Arrange(m_hWnd, code); }
HIMAGELIST	CListView::CreateDragImage(int nIndex, LPPOINT lppt)							{ return ListView_CreateDragImage(m_hWnd, nIndex, lppt); }
BOOL		CListView::DeleteAllItems(void)													{ return ListView_DeleteAllItems(m_hWnd); }
BOOL		CListView::DeleteColumn(int nIndex)												{ return ListView_DeleteColumn(m_hWnd, nIndex); }
BOOL		CListView::DeleteItem(int nIndex)												{ return ListView_DeleteItem(m_hWnd, nIndex); }
HWND		CListView::EditLabel(int nIndex)												{ return ListView_EditLabel(m_hWnd, nIndex); }
BOOL		CListView::EnsureVisible(int nIndex, int fPartialOK)							{ return ListView_EnsureVisible(m_hWnd, nIndex, fPartialOK); }
int			CListView::FindItem(int nStart, const LV_FINDINFO* lplvfi)						{ return ListView_FindItem(m_hWnd, nStart, lplvfi); }
COLORREF	CListView::GetBkColor(void)														{ return ListView_GetBkColor(m_hWnd); }
BOOL		CListView::GetBkImage(LVBKIMAGE* lpbki)											{ return ListView_GetBkImage(m_hWnd, lpbki); }
BOOL		CListView::GetCallbackMask(void)												{ return ListView_GetCallbackMask(m_hWnd); }
BOOL		CListView::GetCheckState(int nIndex)											{ return ListView_GetCheckState(m_hWnd, nIndex); }
BOOL		CListView::GetColumn(int nIndex, LV_COLUMN* lpclmn)								{ return ListView_GetColumn(m_hWnd, nIndex, lpclmn); }
BOOL		CListView::GetColumnOrderArray(int nCount, LPINT lpOrder)						{ return ListView_GetColumnOrderArray(m_hWnd, nCount, lpOrder); }
int			CListView::GetColumnWidth(int nIndex)											{ return ListView_GetColumnWidth(m_hWnd, nIndex); }
int			CListView::GetCountPerPage(void)												{ return ListView_GetCountPerPage(m_hWnd); }
HWND		CListView::GetEditControl(void)													{ return ListView_GetEditControl(m_hWnd); }
DWORD		CListView::GetExtendedListViewStyle(void)										{ return ListView_GetExtendedListViewStyle(m_hWnd); }
HWND		CListView::GetHeader(void)														{ return ListView_GetHeader(m_hWnd); }
#if	!defined(IRIS_WIN32_WCE)
HCURSOR		CListView::GetHotCursor(void)													{ return ListView_GetHotCursor(m_hWnd); }
int			CListView::GetHotItem(void)														{ return ListView_GetHotItem(m_hWnd); }
DWORD		CListView::GetHoverTime(void)													{ return ListView_GetHoverTime(m_hWnd); }
#endif
HIMAGELIST	CListView::GetImageList(int nImage)												{ return ListView_GetImageList(m_hWnd, nImage); }
BOOL		CListView::GetISearchString(LPTSTR lpString)									{ return ListView_GetISearchString(m_hWnd, lpString); }
BOOL		CListView::GetItem(LV_ITEM* lplvi)												{ return ListView_GetItem(m_hWnd, lplvi); }
int			CListView::GetItemCount(void)													{ return ListView_GetItemCount(m_hWnd); }
BOOL		CListView::GetItemPosition(int nIndex, LPPOINT lppt)							{ return ListView_GetItemPosition(m_hWnd, nIndex, lppt); }
BOOL		CListView::GetItemRect(int nIndex, LPRECT lprc, LONG code)						{ return ListView_GetItemRect(m_hWnd, nIndex, lprc, code); }
DWORD		CListView::GetItemSpacing(BOOL bSmall)											{ return ListView_GetItemSpacing(m_hWnd, bSmall); }
UINT		CListView::GetItemState(int nIndex, UINT mask)									{ return ListView_GetItemState(m_hWnd, nIndex, mask); }
void		CListView::GetItemText(int nIndex, int nSubItem, LPTSTR lpText, int cchTextMax)	{ ListView_GetItemText(m_hWnd, nIndex, nSubItem, lpText, cchTextMax); }
int			CListView::GetNextItem(int nIndex, int nFlags)									{ return ListView_GetNextItem(m_hWnd, nIndex, nFlags); }
BOOL		CListView::GetNumberOfWorkAreas(UINT* pnWorkAreas)								{ return ListView_GetNumberOfWorkAreas(m_hWnd, pnWorkAreas); }
BOOL		CListView::GetOrigin(LPPOINT lppt)												{ return ListView_GetOrigin(m_hWnd, lppt); }
UINT		CListView::GetSelectedCount(void)												{ return ListView_GetSelectedCount(m_hWnd); }
int			CListView::GetSelectionMark(void)												{ return ListView_GetSelectionMark(m_hWnd); }
int			CListView::GetStringWidth(LPCTSTR lpString)										{ return ListView_GetStringWidth(m_hWnd, lpString); }
BOOL		CListView::GetSubItemRect(int nIndex, int nSubItem, LONG code, LPRECT lprc)		{ return ListView_GetSubItemRect(m_hWnd, nIndex, nSubItem, code, lprc); }
COLORREF	CListView::GetTextBkColor(void)													{ return ListView_GetTextBkColor(m_hWnd); }
COLORREF	CListView::GetTextColor(void)													{ return ListView_GetTextColor(m_hWnd); }
HWND		CListView::GetToolTips(void)													{ return ListView_GetToolTips(m_hWnd); }
int			CListView::GetTopIndex(void)													{ return ListView_GetTopIndex(m_hWnd); }
#if	!defined(IRIS_WIN32_WCE)
BOOL		CListView::GetUnicodeFormat(void)												{ return ListView_GetUnicodeFormat(m_hWnd); }
#endif
BOOL		CListView::GetViewRect(LPRECT lprc)												{ return ListView_GetViewRect(m_hWnd, lprc); }
BOOL		CListView::GetWorkAreas(int nWorkAreas, LPRECT lprc)							{ return ListView_GetWorkAreas(m_hWnd, nWorkAreas, lprc); }
int			CListView::HitTest(LV_HITTESTINFO* lphti)										{ return ListView_HitTest(m_hWnd, lphti); }
BOOL		CListView::InsertColumn(int nIndex, const LV_COLUMN* lpclmn)					{ return ListView_InsertColumn(m_hWnd, nIndex, lpclmn); }
BOOL		CListView::InsertItem(const LV_ITEM* lplvi)										{ return ListView_InsertItem(m_hWnd, lplvi); }
BOOL		CListView::RedrawItems(int nFirst, int nLast)									{ return ListView_RedrawItems(m_hWnd, nFirst, nLast); }
BOOL		CListView::Scroll(int dx, int dy)												{ return ListView_Scroll(m_hWnd, dx, dy); }
COLORREF	CListView::SetBkColor(COLORREF color)											{ return ListView_SetBkColor(m_hWnd, color); }
BOOL		CListView::SetBkImage(LVBKIMAGE* lpbki)											{ return ListView_SetBkImage(m_hWnd, lpbki); }
BOOL		CListView::SetCallbackMask(BOOL mask)											{ return ListView_SetCallbackMask(m_hWnd, mask); }
void		CListView::SetCheckState(int nIndex, BOOL bCheck)								{ ListView_SetCheckState(m_hWnd, nIndex, bCheck); }
BOOL		CListView::SetColumn(int nIndex, const LV_COLUMN* lpclmn)						{ return ListView_SetColumn(m_hWnd, nIndex, lpclmn); }
BOOL		CListView::SetColumnOrderArray(int nCount, LPINT lpOrder)						{ return ListView_SetColumnOrderArray(m_hWnd, nCount, lpOrder); }
BOOL		CListView::SetColumnWidth(int nIndex, int cx)									{ return ListView_SetColumnWidth(m_hWnd, nIndex, cx); }
DWORD		CListView::SetExtendedListViewStyle(DWORD dwExStyle)							{ return ListView_SetExtendedListViewStyle(m_hWnd, dwExStyle); }
DWORD		CListView::SetExtendedListViewStyleEx(DWORD dwMask, DWORD dwExStyle)			{ return ListView_SetExtendedListViewStyleEx(m_hWnd, dwMask, dwExStyle); }
#if	!defined(IRIS_WIN32_WCE)
HCURSOR		CListView::SetHotCursor(HCURSOR hCursor)										{ return ListView_SetHotCursor(m_hWnd, hCursor); }
int			CListView::SetHotItem(int nIndex)												{ return ListView_SetHotItem(m_hWnd, nIndex); }
DWORD		CListView::SetHoverTime(DWORD dwHoverTimeMs)									{ return ListView_SetHoverTime(m_hWnd, dwHoverTimeMs); }
#endif
DWORD		CListView::SetIconSpacing(int cx, int cy)										{ return ListView_SetIconSpacing(m_hWnd, cx, cy); }
HIMAGELIST	CListView::SetImageList(HIMAGELIST hImage, int nImage)							{ return ListView_SetImageList(m_hWnd, hImage, nImage); }
BOOL		CListView::SetItem(const LV_ITEM* lplvi)										{ return ListView_SetItem(m_hWnd, lplvi); }
void		CListView::SetItemCount(int nCount)												{ ListView_SetItemCount(m_hWnd, nCount); }
void		CListView::SetItemCountEx(int nCount, DWORD dwFlags)							{ ListView_SetItemCountEx(m_hWnd, nCount, dwFlags); }
BOOL		CListView::SetItemPosition(int nIndex, int nX, int nY)							{ return ListView_SetItemPosition(m_hWnd, nIndex, nX, nY); }
void		CListView::SetItemPosition32(int nIndex, int nX, int nY)						{ ListView_SetItemPosition32(m_hWnd, nIndex, nX, nY); }
void		CListView::SetItemState(int nIndex, UINT data, UINT mask)						{ ListView_SetItemState(m_hWnd, nIndex, data, mask); }
void		CListView::SetItemText(int nIndex, int nSubItem, LPTSTR lpText)					{ ListView_SetItemText(m_hWnd, nIndex, nSubItem, lpText); }
int			CListView::SetSelectionMark(int nIndex)											{ return ListView_SetSelectionMark(m_hWnd, nIndex); }
BOOL		CListView::SetTextBkColor(COLORREF color)										{ return ListView_SetTextBkColor(m_hWnd, color); }
BOOL		CListView::SetTextColor(COLORREF color)											{ return ListView_SetTextColor(m_hWnd, color); }
HWND		CListView::SetToolTips(HWND hWndTT)												{ return ListView_SetToolTips(m_hWnd, hWndTT); }
#if	!defined(IRIS_WIN32_WCE)
BOOL		CListView::SetUnicodeFormat(BOOL bUnicode)										{ return ListView_SetUnicodeFormat(m_hWnd, bUnicode); }
#endif
BOOL		CListView::SetWorkAreas(int nWorkAreas, LPRECT lprc)							{ return ListView_SetWorkAreas(m_hWnd, nWorkAreas, lprc); }
BOOL		CListView::SortItems(PFNLVCOMPARE* lpfnCompare, LPARAM lParam)					{ return ListView_SortItems(m_hWnd, lpfnCompare, lParam); }
#if	!defined(IRIS_WIN32_WCE)
BOOL		CListView::SortItemsEx(PFNLVCOMPARE* lpfnCompare, LPARAM lParam)				{ return ListView_SortItemsEx(m_hWnd, lpfnCompare, lParam); }
#else
BOOL		CListView::SortItemsEx(PFNLVCOMPARE* lpfnCompare, LPARAM lParam)				{ return ListView_SortItems(m_hWnd, lpfnCompare, lParam); }
#endif
int			CListView::SubItemHitTest(LPLVHITTESTINFO* lphti)								{ return ListView_SubItemHitTest(m_hWnd, lphti); }
BOOL		CListView::Update(int nIndex)													{ return ListView_Update(m_hWnd, nIndex); }
/**********************************************************************//**
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
