//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCheckListBox.h
 * @brief		`FbN{^tXg{bNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCheckListBox_CPP_

//======================================================================
// include
#include "WXCheckListBox.h"
#include <windowsx.h>
#include <commctrl.h>

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// class

//======================================================================
//! `FbN{bNXp̃f[^NX
class CCheckData : public IIrisObject
{
public:
	int			m_nCheck;
	BOOL		m_bEnabled;
	UINT_PTR	m_dwUserData;
public:
	CCheckData(void)
		: m_nCheck(0), m_bEnabled(TRUE), m_dwUserData(0) {}
};

// CCheckListBox
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCheckListBox::CCheckListBox(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CCheckListBox::CCheckListBox(HWND hWnd)
: CListBox(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCheckListBox::~CCheckListBox(void)
{
	ReleaseCheckData();
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CCheckListBox::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_LISTBOX
		, lpszWindowName
		, dwStyle|LBS_OWNERDRAWFIXED
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CCheckListBox::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_LISTBOX
		, lpszWindowName
		, dwStyle|LBS_OWNERDRAWFIXED
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CCheckListBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_LISTBOX
		, lpszWindowName
		, dwStyle|LBS_OWNERDRAWFIXED
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CCheckListBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_LISTBOX
		, lpszWindowName
		, dwStyle|LBS_OWNERDRAWFIXED
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CCheckListBox::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	// NbN
	case WM_LBUTTONDBLCLK:
	case WM_LBUTTONDOWN:
		{
			PreWndProc(hWnd, uMsg, wParam, lParam);
			if( hWnd != m_hWnd ) return 1;
			int index = (int)::SendMessage(hWnd, LB_GETCURSEL, 0, 0);
			if( index == LB_ERR ) break;
			SetCheck(index, !GetCheck(index));
			::PostMessage( ::GetParent(hWnd), WM_COMMAND, MAKEWPARAM(::GetDlgCtrlID(hWnd), CLBN_CLICKED), (LPARAM)hWnd);
			::InvalidateRect(hWnd, nullptr, FALSE);
		}
		return 1;

	// KEYDOWN
	case WM_KEYDOWN:
		{
			int nChar = (int)wParam;
			if( nChar == VK_SPACE )
			{
				int index = (int)::SendMessage(hWnd, LB_GETCURSEL, 0, 0);
				if( index == LB_ERR ) break;
				SetCheck(index, !GetCheck(index));
				::PostMessage(::GetParent(hWnd), WM_COMMAND, MAKEWPARAM(::GetDlgCtrlID(hWnd), CLBN_CLICKED), (LPARAM)hWnd);
				::InvalidateRect(hWnd, nullptr, FALSE);
			}
		}
		break;

	case WM_VSCROLL:
		break;

	// `
	case WM_PAINT:
		{
			//// TODO:r
			//DRAWITEMSTRUCT dis;
			//dis.CtlID = GetDlgCtrlID(hWnd);
			//HDC hdc = GetDC(hWnd);
			//dis.hDC = hdc;
			//dis.hwndItem = hWnd;
			//::GetWindowRect(hWnd,&dis.rcItem);
			//OwnerDraw(::GetParent(hWnd),&dis);
			//ReleaseDC(hWnd,hdc);
		}
		break;

	// `FbN
	case CLB_GETCHECK:
		{
			int nIndex = (int)lParam;
			LRESULT lResult = ::SendMessage(hWnd, LB_GETITEMDATA, nIndex, 0);
			if (lResult != LB_ERR)
			{
				LPWX_CHECK_DATA pState = (LPWX_CHECK_DATA)lResult;
				if( (pState != nullptr) && FindCheckData(pState) ) return pState->m_nCheck;
			}
		}
		return 0;
	case CLB_SETCHECK:
		{
			int	 nIndex = (int)lParam;
			BOOL nCheck = (BOOL)wParam;
			LRESULT lResult = ::SendMessage(hWnd, LB_GETITEMDATA, nIndex, 0);
			if(lResult != LB_ERR)
			{
				LPWX_CHECK_DATA pState = (LPWX_CHECK_DATA)lResult;
				if( (pState == nullptr) || !FindCheckData(pState) )
				{
					pState = new WX_CHECK_DATA;
					::SendMessage(hWnd, LB_SETITEMDATA, nIndex, (LPARAM)pState);
					m_Data.push_back(pState);
				}
				pState->m_nCheck = nCheck;
			}
		}
		return 0;
	case WM_DESTROY:
		ReleaseCheckData();
		break;
	}
	return CListBox::WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * evV[W󂯂bZ[WM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= evV[W󂯂
 * @param [in]	uMsg	= evV[W󂯂
 * @param [in]	wParam	= evV[W󂯂
 * @param [in]	lParam	= evV[W󂯂
*//***********************************************************************/
LRESULT CCheckListBox::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_DRAWITEM:
		OwnerDraw((LPDRAWITEMSTRUCT)lParam);
		break;
	}
	return CSubClass::RecvParentMessage(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * OwnerDraw
 *
*//***********************************************************************/
int CCheckListBox::OwnerDraw(LPDRAWITEMSTRUCT lpdi)
{
	HDC hdc = lpdi->hDC;
	if( !(lpdi->itemAction & ODA_DRAWENTIRE ) ) return 0;

	HWND hWnd = lpdi->hwndItem;
	int	 cyItem		= lpdi->rcItem.bottom - lpdi->rcItem.top;
	TEXTMETRIC tm;
	GetTextMetrics(hdc,&tm);
	int	 cyText		= tm.tmHeight;
	BOOL fDisabled	= !::IsWindowEnabled(hWnd); 

	COLORREF newTextColor = fDisabled ?
		RGB(0x80, 0x80, 0x80) : GetSysColor(COLOR_WINDOWTEXT);	// light gray
	COLORREF oldTextColor = SetTextColor(hdc,newTextColor);

	COLORREF newBkColor = GetSysColor(COLOR_WINDOW);
	COLORREF oldBkColor = SetBkColor(hdc,newBkColor);

	if(newTextColor == newBkColor)
		newTextColor = RGB(0xC0, 0xC0, 0xC0);	// dark gray

#if 0	// TODO:Ƃ肠Rg
	if(!fDisabled && ((lpDrawItemStruct->itemState & ODS_SELECTED) != 0))
	{
		newTextColor = GetSysColor(COLOR_HIGHLIGHTTEXT);
		SetTextColor(hdc,newTextColor);
		newBkColor = GetSysColor(COLOR_HIGHLIGHT);
		SetBkColor(hdc,newBkColor);
	}
#endif

	HBRUSH hBrush = CreateSolidBrush(newBkColor);
	HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hBrush);
	HPEN hOldPen = (HPEN)SelectObject(hdc, GetStockObject(NULL_PEN));
	Rectangle(hdc, lpdi->rcItem.left, lpdi->rcItem.top
		, lpdi->rcItem.right, lpdi->rcItem.bottom );


	int box_h = cyItem-4;
	int box_w = box_h;
	LPTSTR strText = nullptr;
	int	  strLen = 0;
	int len = (int)::SendMessage(hWnd, LB_GETTEXTLEN, lpdi->itemID, 0);
	if( len != LB_ERR )
	{
		strText = new TCHAR [len+1];
		::SendMessage(hWnd, LB_GETTEXT, lpdi->itemID, (LPARAM)strText);
	}
	ExtTextOut(hdc,lpdi->rcItem.left + cyItem,
		lpdi->rcItem.top + max(0, (cyItem - cyText) / 2),
		ETO_OPAQUE, &(lpdi->rcItem), strText, strLen, nullptr);
	IRIS_SAFE_DELETE_ARRAY( strText );

	// y쐬
	HPEN hPen = CreatePen(PS_SOLID,1,RGB(0x80, 0x80, 0x80));
	SelectObject(hdc,hPen);
	SelectObject(hdc, GetStockObject(NULL_BRUSH));
	// lp`̕`
	Rectangle(hdc,2,2,box_w,box_h);
	if( ::SendMessage(hWnd, CLB_GETCHECK, 0, lpdi->itemID) )
	{
		HPEN hPen2 = CreatePen(PS_SOLID, 2, newTextColor);
		SelectObject(hdc, hPen2);
		
		// TODOFƂ܂ʂ
		MoveToEx(hdc, 3			, box_h/2	, nullptr);
		LineTo	(hdc, box_w/2-1	, box_h-2	);
		LineTo	(hdc, box_w		, box_h/3	);

		SelectObject(hdc, hOldPen);
		DeleteObject(hPen2);
	}

	SetTextColor(hdc, oldTextColor);
	SetBkColor(hdc, oldBkColor);

	// uVAy̔p
	SelectObject( hdc, hOldPen );
	SelectObject( hdc, hOldBrush );
	DeleteObject( hPen );
	DeleteObject( hBrush );
	return 0;
}

/**********************************************************************//**
 *
 * `FbNԂ̎擾
 *
*//***********************************************************************/
BOOL CCheckListBox::GetCheck(int nIndex)
{
	return (BOOL)::SendMessage(m_hWnd, CLB_GETCHECK, 0, (LPARAM)nIndex);
}
/**********************************************************************//**
 *
 * `FbNԂ̐ݒ
 *
*//***********************************************************************/
LRESULT CCheckListBox::SetCheck(int nIndex, BOOL nCheck)
{
	return ::SendMessage(m_hWnd, CLB_SETCHECK, (WPARAM)nCheck, (LPARAM)nIndex);
}
/**********************************************************************//**
 *
 * `FbNf[^̑݊mF
 *
*//***********************************************************************/
CCheckListBox::LPWX_CHECK_DATA CCheckListBox::FindCheckData(void* pData)
{
	for( vecCheckData::iterator it = m_Data.begin(), end = m_Data.end(); it != end; ++it )
	{
		if( *it == pData ) return *it;
	}
	return nullptr;
}
/**********************************************************************//**
 *
 * `FbNf[^̉
 *
*//***********************************************************************/
void CCheckListBox::ReleaseCheckData(void)
{
	for( vecCheckData::iterator it = m_Data.begin(); it != m_Data.end(); )
	{
		LPWX_CHECK_DATA p = *it;
		it = m_Data.erase(it);
		delete p;
	}
}

}	// end of namespace wx
}	// end of namespace iris
