//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComboBox.cpp
 * @brief		R{{bNXRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXComboBox_CPP_

//======================================================================
// include
#include "WXComboBox.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function
//**********************************************************************
//
// ڂ̒ǉ
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	pString	= ǉ镶
// @return	ǉꂽCfbNX
//			s CB_ERR
//			ȂꍇCB_ERRSPACE 
//**********************************************************************
//int	ComboBox_AddString(HWND hWnd, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, CB_ADDSTRING, 0, (LPARAM)pString);
//}
//**********************************************************************
//
// ڂ̍폜
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= 폜CfbNX
// @return	ڂ̐
//**********************************************************************
//int		ComboBox_DeleteString(HWND hWnd, int nIndex)
//{
//	return (int)SendMessage(hWnd, CB_DELETESTRING, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * ڂ̑S폜
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ڂ̐
*//***********************************************************************/
void		ComboBox_DeleteStringAll(HWND hWnd)
{
	int num = 0;
	do
	{
		num = ComboBox_DeleteString(hWnd, 0);
	} while(num != 0 && num != CB_ERR);
}
//**********************************************************************
//
// t@Cڂ̎擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	DDL		= t@C(DDL_***)
// @param	path	= or΃pXiChJ[hj
// @return	Ō̃t@C̃CfbNX
//			s CB_ERR
//			ȂꍇCB_ERRSPACE 
//**********************************************************************
//int		ComboBox_Dir(HWND hWnd, int DDL, LPCTSTR path)
//{
//	return SendMessage(hWnd, CB_DIR, (WPARAM)DDL, (LPARAM)path);
//}
//**********************************************************************
//
// ̌iOvj
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= JnCfbNX
// @param	pString	= 镶
// @return	CfbNX
//			s CB_ERR
//**********************************************************************
//int		ComboBox_FindString(HWND hWnd, int nIndex, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, CB_FINDSTRING, (WPARAM)nIndex, (LPARAM)pString);
//}
/**********************************************************************//**
 *
 * ̌iSvj
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= JnCfbNX
 * @param [in]	pString		= 镶
 * @return	CfbNX
 *			s CB_ERR
*//***********************************************************************/
//int		ComboBox_FindStringExact(HWND hWnd, int nIndex, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, CB_FINDSTRINGEXACT, (WPARAM)nIndex, (LPARAM)pString);
//}
//**********************************************************************
//
// ڐ̎擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @return	ڂ̐
//			s CB_ERR
//**********************************************************************
//int		ComboBox_GetCount(HWND hWnd)
//{
//	return (int)SendMessage(hWnd, CB_GETCOUNT, 0, 0);
//}
//**********************************************************************
//
// I𒆂̃CfbNX̎擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @return	I𒆂̃CfbNX
//			s CB_ERR
//**********************************************************************
//int		ComboBox_GetCurSel(HWND hWnd)
//{
//	return (int)SendMessage(hWnd, CB_GETCURSEL, 0, 0);
//}
/**********************************************************************//**
 *
 * hbv_EXg{bNX̃XN[W̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lprc	= o
 * @return	
*//***********************************************************************/
//BOOL	ComboBox_GetDroppedControlRect(HWND hWnd, LPRECT lprc)
//{
//	return (BOOL)SendMessage(hWnd, CB_GETDROPPEDCONTROLRECT, 0, (LPARAM)lprc);
//}
/**********************************************************************//**
 *
 * Xg̕\Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	\Ă邩
*//***********************************************************************/
//BOOL	ComboBox_GetDroppedState(HWND hWnd)
//{
//	return (BOOL)SendMessage(hWnd, CB_GETDROPPEDSTATE, 0, 0);
//}
/**********************************************************************//**
 *
 * ŏ̉̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	sNZPʂ̃Xg̍ŏ
 *			sCB_ERR
*//***********************************************************************/
int		ComboBox_GetDroppedWidth(HWND hWnd)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, CB_GETDROPPEDWIDTH, 0, 0);
#else
	return CB_ERR;
#endif
}
/**********************************************************************//**
 *
 * GfBbg̑I͈͂̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pStartPos	= óiJnʒuj
 * @param [in]	pEndPos		= óiIʒuj
 * @return	ʃ[hɊJnʒu
 *			ʃ[hɏIʒu
*//***********************************************************************/
DWORD	ComboBox_GetEditSelEx(HWND hWnd, int* pStartPos, int* pEndPos)
{
	return (DWORD)SendMessage(hWnd, CB_GETEDITSEL, (WPARAM)pStartPos, (LPARAM)pEndPos);
}
/**********************************************************************//**
 *
 * ftHgъg[U[C^tFCX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	TRUE:gAFALSE:ftHg
*//***********************************************************************/
//BOOL	ComboBox_GetExtendedUI(HWND hWnd)
//{
//	return (BOOL)SendMessage(hWnd, CB_GETEXTENDEDUI, 0, 0);
//}
/**********************************************************************//**
 *
 * XN[\̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	sNZPʂ̃XN[\ȕ
*//***********************************************************************/
int		ComboBox_GetHorizontalExtent(HWND hWnd)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, CB_GETHORIZONTALEXTENT, 0, 0);
#else
	return CB_ERR;
#endif
}
//**********************************************************************
//
// ACeɊ֘Atꂽl̎擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= CfbNX
// @return	32bitl
//**********************************************************************
//LRESULT	ComboBox_GetItemData(HWND hWnd, int nIndex)
//{
//	return SendMessage(hWnd, CB_GETITEMDATA, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * ڂ̍̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= CfbNX
 * @return	sNZPʂ̍
 *			s CB_ERR
*//***********************************************************************/
//int		ComboBox_GetItemHeight(HWND hWnd, int nIndex)
//{
//	return (int)SendMessage(hWnd, CB_GETITEMHEIGHT, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * [P̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ʃ[hɍR[h
 *			ʃ[hɌꎯʎq
*//***********************************************************************/
LCID	ComboBox_GetLocale(HWND hWnd)
{
	return (LCID)SendMessage(hWnd, CB_GETLOCALE, 0, 0);
}
//**********************************************************************
//
// Xg̍ڂ̕擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= CfbNX
// @param	lpBuf	= o̓obt@
// @return	
//			s CB_ERR
//**********************************************************************
//int		ComboBox_GetLBText(HWND hWnd, int nIndex, LPCTSTR lpBuf)
//{
//	return (int)SendMessage(hWnd, CB_GETLBTEXT, (WPARAM)nIndex, (LPARAM)lpBuf);
//}
//**********************************************************************
//
// Xg̍ڂ̕擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= CfbNX
// @return	
//			s CB_ERR
//**********************************************************************
//int		ComboBox_GetLBTextLen(HWND hWnd, int nIndex)
//{
//	return (int)SendMessage(hWnd, CB_GETLBTEXTLEN, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * 擪̃CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	CfbNX
 *			s CB_ERR
*//***********************************************************************/
int		ComboBox_GetTopIndex(HWND hWnd)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, CB_GETTOPINDEX, 0, 0);
#else
	return CB_ERR;
#endif
}
/**********************************************************************//**
 *
 * ̊蓖
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	add		= 鍀ڐ
 * @param [in]	mem		= ڕ̃
 * @return	
*//***********************************************************************/
LRESULT	ComboBox_InitStorage(HWND hWnd, int nItems, UINT nBytes)
{
#if(WINVER >= 0x0400)
	return SendMessage(hWnd, CB_INITSTORAGE, (WPARAM)nItems, (LPARAM)nBytes);
#else
	return CB_ERR;
#endif
}
//**********************************************************************
//
// ڑ}
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= CfbNX
// @param	pString	= ǉ镶
// @return	ǉCfbNX
//			s CB_ERR
//			ȂꍇCB_ERRSPACE
//**********************************************************************
//int		ComboBox_InsertString(HWND hWnd, int nIndex, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, CB_INSERTSTRING, (WPARAM)nIndex, (LPARAM)pString);
//}
//**********************************************************************
//
// GfBbg͍̓ő啶w
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nLenMax	= ő啶
//**********************************************************************
//int		ComboBox_LimitText(HWND hWnd, int nLenMax)
//{
//	SendMessage(hWnd, CB_LIMITTEXT, (WPARAM)nLenMax, 0);
//}
//**********************************************************************
//
// Xg̍ڂ̕擾
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
//**********************************************************************
//int		ComboBox_ResetContent(HWND hWnd)
//{
//	return (int)SendMessage(hWnd, CB_RESETCONTENT, 0, 0);
//}
//**********************************************************************
//
// w蕶ɑOv鍀ڂI
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= JnCfbNX
// @param	pString	= 镶
// @return	ICfbNX
//			s CB_ERR
//**********************************************************************
//int		ComboBox_SelectString(HWND hWnd, int nIndex, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, CB_SELECTSTRING, (WPARAM)nIndex, (LPARAM)pString);
//}
//**********************************************************************
//
// ڂI
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= ICfbNX
// @return	ICfbNX
//			s CB_ERR
//**********************************************************************
//int		ComboBox_SetCurSel(HWND hWnd, int nIndex)
//{
//	return (int)SendMessage(hWnd, CB_SETCURSEL, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * Xg̍ő啝w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pixelWidth	= ő啝
 * @return	V
 *			sCB_ERR
*//***********************************************************************/
int		ComboBox_SetDroppedWidth(HWND hWnd, int pixelWidth)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, CB_SETDROPPEDWIDTH, (WPARAM)pixelWidth, 0);
#else
	return CB_ERR;
#endif
}
//**********************************************************************
//
// GfBbg̎wʒuI
//
//----------------------------------------------------------------------
// @param	hWnd		= Ώۂ̃EBhEnh
// @param	pStartPos	= Jnʒu
// @param	pEndPos		= Iʒu
// @return	ʃ[hɊJnʒu
//			ʃ[hɏIʒu
//**********************************************************************
//BOOL	ComboBox_SetEditSel(HWND hWnd, WORD Start, WORD End)
//{
//	return (SendMessage(hWnd, CB_SETEDITSEL, 0, MAKELPARAM(Start,End)) != CB_ERR) ? 1 : 0;
//}
/**********************************************************************//**
 *
 * ftHgъg[U[C^tFCX̑I
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bExtend		= TRUE:gAFALSE:ftHg
 * @return	
*//***********************************************************************/
//BOOL	ComboBox_SetExtendedUI(HWND hWnd, BOOL bExtend)
//{
//	return (SendMessage(hWnd, CB_SETEXTENDEDUI, (WPARAM)bExtend, 0) != CB_ERR) ? 1 : 0;
//}
/**********************************************************************//**
 *
 * XN[\̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pixelWidth	= sNZPʂ̃XN[\ȕ
 * @return	
*//***********************************************************************/
BOOL	ComboBox_SetHorizonTalextent(HWND hWnd, int pixelWitdth)
{
#if(WINVER >= 0x0400)
	SendMessage(hWnd, CB_SETHORIZONTALEXTENT, (WPARAM)pixelWitdth, 0);
	return 1;
#else
	return 0;
#endif
}
//**********************************************************************
//
// lACeɊ֘At
//
//----------------------------------------------------------------------
// @param	hWnd	= Ώۂ̃EBhEnh
// @param	nIndex		= CfbNX
// @param	Data	= l
// @return	
//**********************************************************************
//BOOL	ComboBox_SetItemData(HWND hWnd, int nIndex, LPARAM Data)
//{
//	return (SendMessage(hWnd, CB_SETITEMDATA, (WPARAM)nIndex, Data) != CB_ERR) ? 1 : 0;
//}
/**********************************************************************//**
 *
 * ڂ̍̎w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIndex			= CfbNX
 * @param [in]	pixelHeight	= sNZPʂ̍
 * @return	
*//***********************************************************************/
//BOOL	ComboBox_SetItemHeight(HWND hWnd, int nIndex, int pixelHeight)
//{
//	return (SendMessage(hWnd, CB_SETITEMHEIGHT, (WPARAM)nIndex, (LPARAM)pixelHeight) != CB_ERR) ? 1 : 0;
//}

/**********************************************************************//**
 *
 * [P̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	Country	= R[h
 * @param [in]	Lang	= ꎯʎq
 * @return	ȑÕ[P
 *			ʃ[hɍR[h
 *			ʃ[hɌꎯʎq
*//***********************************************************************/
LCID	ComboBox_SetLocale(HWND hWnd, WORD Country, WORD Lang)
{
	return (LCID)SendMessage(hWnd, CB_SETLOCALE, MAKEWPARAM(Lang,Country), 0);
}
/**********************************************************************//**
 *
 * [P̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	Locale	= [P
 * @return	ȑÕ[P
 *			ʃ[hɍR[h
 *			ʃ[hɌꎯʎq
*//***********************************************************************/
LCID	ComboBox_SetLocale(HWND hWnd, LCID Locale)
{
	return (LCID)SendMessage(hWnd, CB_SETLOCALE, (WPARAM)Locale, 0);
}
/**********************************************************************//**
 *
 * 擪̃CfbNXw
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
BOOL	ComboBox_SetTopIndex(HWND hWnd, int nIndex)
{
#if(WINVER >= 0x0400)
	return (SendMessage(hWnd, CB_SETTOPINDEX, (WPARAM)nIndex, 0) != CB_ERR) ? 1 : 0;
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * Xg\E\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	bShow	= TRUE:\AFALSE:\
*//***********************************************************************/
void	ComboBox_ShowDropDown(HWND hWnd, BOOL bShow)
{
	SendMessage(hWnd, CB_SHOWDROPDOWN, (WPARAM)bShow, 0);
}

//======================================================================
// class
// CComboBox
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CComboBox::CComboBox(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CComboBox::CComboBox(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CComboBox::~CComboBox(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CComboBox::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_COMBOBOX
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CComboBox::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_COMBOBOX
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CComboBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_COMBOBOX
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CComboBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_COMBOBOX
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CComboBox::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
int		CComboBox::AddString(LPCTSTR pString)					{ return ComboBox_AddString(m_hWnd, pString); }
int		CComboBox::DeleteString(int nIndex)						{ return ComboBox_DeleteString(m_hWnd, nIndex); }
void	CComboBox::DeleteStringAll(void)						{ ComboBox_DeleteStringAll(m_hWnd); }
LRESULT	CComboBox::Dir(int DDL, LPCTSTR path)					{ return ComboBox_Dir(m_hWnd, DDL, path); }
int		CComboBox::FindString(int nIndex, LPCTSTR pString)		{ return ComboBox_FindString(m_hWnd, nIndex, pString); }
int		CComboBox::FindStringExact(int nIndex, LPCTSTR pString)	{ return ComboBox_FindStringExact(m_hWnd, nIndex, pString); }
int		CComboBox::GetCount(void)								{ return ComboBox_GetCount(m_hWnd); }
int		CComboBox::GetCurSel(void)								{ return ComboBox_GetCurSel(m_hWnd); }
void	CComboBox::GetDroppedControlRect(LPRECT lprc)			{ ComboBox_GetDroppedControlRect(m_hWnd, lprc); }
BOOL	CComboBox::GetDroppedState(void)						{ return ComboBox_GetDroppedState(m_hWnd); }
int		CComboBox::GetDroppedWidth(void)						{ return ComboBox_GetDroppedWidth(m_hWnd); }
DWORD	CComboBox::GetEditSel(void)								{ return ComboBox_GetEditSel(m_hWnd); }
DWORD	CComboBox::GetEditSel(int* pStartPos, int* pEndPos)		{ return ComboBox_GetEditSelEx(m_hWnd, pStartPos, pEndPos); }
BOOL	CComboBox::GetExtendedUI(void)							{ return ComboBox_GetExtendedUI(m_hWnd); }
int		CComboBox::GetHorizontalExtent(void)					{ return ComboBox_GetHorizontalExtent(m_hWnd); }
LRESULT	CComboBox::GetItemData(int nIndex)						{ return ComboBox_GetItemData(m_hWnd, nIndex); }
int		CComboBox::GetItemHeight(void)							{ return ComboBox_GetItemHeight(m_hWnd); }
int		CComboBox::GetLBText(int nIndex, LPCTSTR lpBuf)			{ return ComboBox_GetLBText(m_hWnd, nIndex, lpBuf); }
int		CComboBox::GetLBTextLen(int nIndex)						{ return ComboBox_GetLBTextLen(m_hWnd, nIndex); }
LCID	CComboBox::GetLocale(void)								{ return ComboBox_GetLocale(m_hWnd); }
int		CComboBox::GetTopIndex(void)							{ return ComboBox_GetTopIndex(m_hWnd); }
LRESULT	CComboBox::InitStorage(int nItems, UINT nBytes)			{ return ComboBox_InitStorage(m_hWnd, nItems, nBytes); }
int		CComboBox::InsertString(int nIndex, LPCTSTR pString)	{ return ComboBox_InsertString(m_hWnd, nIndex, pString); }
void	CComboBox::LimitText(int nLenMax)						{ ComboBox_LimitText(m_hWnd, nLenMax); }
void	CComboBox::ResetContent(void)							{ ComboBox_ResetContent(m_hWnd); }
int		CComboBox::SelectString(int nIndex, LPCTSTR pString)	{ return ComboBox_SelectString(m_hWnd, nIndex, pString); }
int		CComboBox::SetCurSel(int nIndex)						{ return ComboBox_SetCurSel(m_hWnd, nIndex); }
int		CComboBox::SetDroppedWidth(int pixelWidth)				{ return ComboBox_SetDroppedWidth(m_hWnd, pixelWidth); }
BOOL	CComboBox::SetHorizonTalextent(int pixelWidth)			{ return ComboBox_SetHorizonTalextent(m_hWnd, pixelWidth); }
BOOL	CComboBox::SetEditSel(WORD Start, WORD End)				{ return ComboBox_SetEditSel(m_hWnd, Start, End); }
BOOL	CComboBox::SetExtendedUI(BOOL bExtend)					{ return ComboBox_SetExtendedUI(m_hWnd, bExtend); }
BOOL	CComboBox::SetItemData(int nIndex, LPARAM Data)			{ return ComboBox_SetItemData(m_hWnd, nIndex, Data); }
BOOL	CComboBox::SetItemHeight(int nIndex, int pixelHeight)	{ return ComboBox_SetItemHeight(m_hWnd, nIndex, pixelHeight); }
LCID	CComboBox::SetLocale(WORD Country, WORD Lang)			{ return ComboBox_SetLocale(m_hWnd, Country, Lang); }
LCID	CComboBox::SetLocale(LCID Locale)						{ return ComboBox_SetLocale(m_hWnd, Locale); }
BOOL	CComboBox::SetTopIndex(int nIndex)						{ return ComboBox_SetTopIndex(m_hWnd, nIndex); }
void	CComboBox::ShowDropDown(BOOL bShow)						{ ComboBox_ShowDropDown(m_hWnd, bShow); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
